package ru.yandex.autotests.mediaplan.datafactories;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.Mediaplan;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.mediaplan.datafactories.ClientIdsFactory.getDefaultClientID;

public class AddMediplanFactory {
    private AddMediplanFactory() {
    }

    public static List<Mediaplan> oneMediaplan() {
        return nMediaplan(1);
    }

    public static List<Mediaplan> twoMediaplans() {
        return nMediaplan(2);
    }

    public static List<Mediaplan> hundredMediaplans() {
        return nMediaplan(100);
    }
    public static List<Mediaplan> nMediaplan(int n) {
        List<Mediaplan> mediaplans = new ArrayList<>(n);
        for (int i = 0; i < n; i++) {
            mediaplans.add(new Mediaplan()
                    .withMediaplannerUID(getDefaultClientID())
                    .withClientId(getDefaultClientID()));
        }
        return mediaplans;
    }
}
