package ru.yandex.autotests.mediaplan.datafactories;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.ParamsApi5AddRequests;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.Request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static ru.yandex.autotests.mediaplan.rules.MediaplanRule.getClient;

public class AddRequestsFactory {
    public static final Long DEFAULT_AUTHOR_ID = getClient();
    public static final Long DEFAULT_CLIENT_ID = getClient();
    public static final String DEFAULT_COMMENT = "comment";

    private AddRequestsFactory() {
    }

    public static ParamsApi5AddRequests defaultAddRequest() {
        return new ParamsApi5AddRequests().withRequests(Collections.singletonList(new Request()
                .withAuthorUID(DEFAULT_AUTHOR_ID)
                .withClientId(DEFAULT_CLIENT_ID)
                .withComment(DEFAULT_COMMENT)
                .withType(Request.Type.MODERATE)));
    }
    public static ParamsApi5AddRequests defaultAddRequestWithAuthorId(Long uid) {
        return new ParamsApi5AddRequests().withRequests(Collections.singletonList(new Request()
                .withAuthorUID(uid)
                .withClientId(DEFAULT_CLIENT_ID)
                .withComment(DEFAULT_COMMENT)
                .withType(Request.Type.MODERATE)));
    }

    public static ParamsApi5AddRequests hundredRequests() {
        return nRequests(100);
    }

    public static ParamsApi5AddRequests twoDefaultRequest() {
        return nRequests(2);
    }

    private static ParamsApi5AddRequests nRequests(int n) {
        List<Request> requests = new ArrayList<>();
        for (int i = 0; i < n; i ++) {
            requests.add(new Request()
                    .withAuthorUID(DEFAULT_AUTHOR_ID)
                    .withClientId(DEFAULT_CLIENT_ID)
                    .withComment(DEFAULT_COMMENT)
                    .withType(Request.Type.MODERATE));
        }
        return new ParamsApi5AddRequests().withRequests(requests);
    }
}
