package ru.yandex.autotests.mediaplan.datafactories;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.ParamsApi5AddSitelinks;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.Sitelink;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.SitelinksSet;

import java.util.ArrayList;
import java.util.List;

public class AddSiteLinkFactory {
    private AddSiteLinkFactory() {
    }

    public static ParamsApi5AddSitelinks oneSiteLinksSets() {
        return nSitelinksSets(1);
    }

    public static ParamsApi5AddSitelinks twoSiteLinksSets() {
        return nSitelinksSets(2);
    }

    private static ParamsApi5AddSitelinks nSitelinksSets(int n) {
        List<SitelinksSet> sitelinksSets = new ArrayList<SitelinksSet>(n);
        for (int i = 0; i < n; i++) {
            sitelinksSets.add(new SitelinksSet().withSitelinks(nSiteLinks(2)));
        }
        return new ParamsApi5AddSitelinks().withSitelinksSets(sitelinksSets);
    }

    private static List<Sitelink> nSiteLinks(int n) {
        List<Sitelink> sitelinks = new ArrayList<>(n);
        for (int i = 0; i < n; i++) {
            sitelinks.add(new Sitelink().withHref("https://ya.ru/" + i).withTitle("123" + i));
        }
        return sitelinks;
    }

    private static ParamsApi5AddSitelinks unickTitle(String title) {
        ParamsApi5AddSitelinks result = oneSiteLinksSets();
        result.getSitelinksSets().get(0).getSitelinks().get(0).setTitle(title);
        return result;
    }

    public static ParamsApi5AddSitelinks ukrainTitle() {
        return unickTitle("Горілка");
    }

    public static ParamsApi5AddSitelinks turkishTitle() {
        return unickTitle("türkiye");
    }
    public static ParamsApi5AddSitelinks kazahTitle() {
        return unickTitle("арақ");
    }
}
