package ru.yandex.autotests.mediaplan.datafactories;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.ParamsApi5AddVcards;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.Phone;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.VCard;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.autotests.mediaplan.rules.MediaplanRule.getClient;

public class AddVCardFactory {
    private AddVCardFactory() {
    }

    public static ParamsApi5AddVcards oneVCard(){
        return nVCards(1);
    }
    public static ParamsApi5AddVcards twoVCard(){
        return nVCards(2);
    }
    public static ParamsApi5AddVcards thousandVCard(){
        return nVCards(1000);
    }

    public static ParamsApi5AddVcards tooMuchVCard(){
        return nVCards(1001);
    }
    public static ParamsApi5AddVcards oneCorrectVCardOtherNot(){
        ParamsApi5AddVcards result = nVCards(2);
        result.getVCards().get(0).getPhone().withPhoneNumber("123");
        return result;
    }

    private static ParamsApi5AddVcards nVCards(int n){
        List<VCard> vCardList = new ArrayList<>(n);
        for (int i = 0; i <n; i ++) {
            vCardList.add(minVcard());
        }
        return new ParamsApi5AddVcards().withVCards(vCardList);
    }

    private static VCard minVcard (){
        return new VCard().withCity("city")
                .withCompanyName("company_name")
                .withCountry("counrty")
                .withPhone(
                        new Phone()
                                .withPhoneNumber("12312")
                                .withCityCode("7")
                                .withCountryCode("+9")
                )
                .withWorkTime("0;0;0;0;0;0")
                .withMetroStationId(getClient());
    }
}
