package ru.yandex.autotests.mediaplan.datafactories;

import org.apache.commons.lang3.RandomStringUtils;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.Keyword;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_bids_set_auto.Bid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class KeyWordsFactory {
    private KeyWordsFactory() {
    }

    public static List<Keyword> oneKeyWord() {
        return nSymbolsWord(1);
    }
    public static List<Keyword> twoKeyWords() {
        return nSymbolsWord(2);
    }

    public static List<Keyword> maxKeyWords() {
        return nSymbolsWord(200);
    }

    public static List<Keyword> tooMuchKeyWords() {
        return nSymbolsWord(201);
    }

    public static List<Keyword> tenThousandsKeyWords() {
        return nSymbolsWord(10000);
    }

    public static List<Keyword> oneThousandKeyWords() {
        return nSymbolsWord(1000);
    }

    private static List<Keyword> nSymbolsWord(int n) {
        List<Keyword> keywords = new ArrayList<>(n);
        for (int i = 0; i < n; i++) {
            keywords.add(new Keyword().withKeyword(RandomStringUtils.randomAlphabetic(8)));
        }
        return keywords;
    }

    public static List<Keyword> oneKeyWordWithPosition() {
        return nKeyWordWithPosition(1);
    }

    public static List<Keyword> twoKeyWordWithPosition() {
        return nKeyWordWithPosition(2);
    }

    private static List<Keyword> nKeyWordWithPosition(int n) {
        return nSymbolsWord(n).stream().map(x->x.withPosition(Bid.Position.P_11)).collect(Collectors.toList());
    }

    public static List<Keyword> oneLongKeyWord() {
        return Collections.singletonList(new Keyword().withKeyword(RandomStringUtils.randomAlphabetic(4096)));
    }

    public static List<Keyword> tooLongKeyWord() {
        return Collections.singletonList(new Keyword().withKeyword(RandomStringUtils.randomAlphabetic(4097)));
    }

    private static Keyword phraseOfNWordsOfLengthL(int n, int l) {
        String phrase = "";
        for (int i = 0; i < n - 1; i++) {
            phrase += RandomStringUtils.randomAlphabetic(l) + " ";
        }
        phrase += nSymbolsWord(l);
        return new Keyword().withKeyword(phrase);
    }

    private static List<Keyword> nPhrases(int n, int phraseSize, int wordSize) {
        return IntStream.range(0, n).mapToObj(x->phraseOfNWordsOfLengthL(phraseSize, wordSize)).collect(Collectors.toList());
    }

    public static List<Keyword> maxPhrases() {
        return nPhrases(10, 7, 585);
    }
    public static List<Keyword> oneCorrectOtherNot() {
        List<Keyword> result = nSymbolsWord(2);
        result.get(0).setKeyword(RandomStringUtils.randomAlphabetic(4097));
        return result;
    }
}
