package ru.yandex.autotests.mediaplan.datafactories;

import org.apache.commons.lang3.RandomStringUtils;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_predict_reset_ctr_keywords.PredictResetCTR;

import java.util.ArrayList;
import java.util.List;

public class PredictResetCtrFactory {
    private PredictResetCtrFactory() {
    }

    public static List<PredictResetCTR> onePredict() {
        return nPredict(1);
    }
    public static List<PredictResetCTR> twoPredict() {
        return nPredict(2);
    }

    public static List<PredictResetCTR> OneCorrectOtherNot() {
        List<PredictResetCTR> result = nPredict(2);
        result.get(0).withNewText(RandomStringUtils.randomAlphabetic(9999));
        return result;
    }

    public static List<PredictResetCTR> thousandPredict() {
        return nPredict(1000);
    }

    private static List<PredictResetCTR> nPredict(int n) {
        List<PredictResetCTR> predictResetCTRs = new ArrayList<>(n);
        for (int i = 0; i < n; i ++) {
            predictResetCTRs.add(new PredictResetCTR().withNewText(RandomStringUtils.randomAlphabetic(8))
                    .withOldText("old_text"));
        }
        return predictResetCTRs;
    }
}
