package ru.yandex.autotests.mediaplan.datafactories;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.AdGroup;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_adgroups.ParamsApi5UpdateAdgroups;

import java.util.List;
import java.util.stream.Collectors;

public class UpdateAdGroupsFactory {
    private UpdateAdGroupsFactory() {
    }

    public static ParamsApi5UpdateAdgroups makeOneFieldChanged(final List<AdGroup> adGroups) {
        return new ParamsApi5UpdateAdgroups().withAdGroups(
                adGroups.stream().map(
                        x -> new AdGroup()
                                .withName("new_name")
                                .withDirectAdGroupId(x.getDirectAdGroupId())
                                .withId(x.getId())
                                .withNegativeKeywords(x.getNegativeKeywords())
                                .withRegionIds(x.getRegionIds())
                ).collect(Collectors.toList()));
    }

    public static ParamsApi5UpdateAdgroups makeOnlyOneFieldChanged(final List<AdGroup> adGroups) {
        return new ParamsApi5UpdateAdgroups().withAdGroups(
                makeOneFieldChanged(adGroups)
                        .getAdGroups().stream().map(
                        x -> x.withDirectAdGroupId(null)
                                .withNegativeKeywords(null)
                                .withRegionIds(null)
                ).collect(Collectors.toList()));
    }

    public static ParamsApi5UpdateAdgroups makeOneRequiredFieldNullChanged(final List<AdGroup> adGroups) {
        return new ParamsApi5UpdateAdgroups().withAdGroups(
                adGroups.stream().map(x ->
                        new AdGroup().withName("")
                                .withDirectAdGroupId(x.getDirectAdGroupId())
                                .withId(x.getId())
                                .withNegativeKeywords(x.getNegativeKeywords())
                                .withRegionIds(x.getRegionIds()))
                        .collect(Collectors.toList()));
    }

    public static ParamsApi5UpdateAdgroups makeOnlyOneRequiredFieldNullChanged(final List<AdGroup> adGroups) {
        return new ParamsApi5UpdateAdgroups().withAdGroups(
                makeOneRequiredFieldNullChanged(adGroups)
                        .getAdGroups().stream().map(
                        x -> x.withDirectAdGroupId(null)
                                .withNegativeKeywords(null)
                                .withRegionIds(null)
                ).collect(Collectors.toList()));
    }

}
