package ru.yandex.autotests.mediaplan.datafactories;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Ad;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.TextAd;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_ads.ParamsApi5UpdateAds;

import java.util.List;
import java.util.stream.Collectors;

public class UpdateAdsFactory {
    private UpdateAdsFactory() {
    }

    public static ParamsApi5UpdateAds makeOneFieldChanged(final List<Ad> ad) {
        return new ParamsApi5UpdateAds().withAds(ad.stream().map(x ->
                new Ad().withTextAd(new TextAd().withText(x.getTextAd().getText()).withTitle("new_title"))
                        .withAdGroupId(x.getAdGroupId()).withId(x.getId())).collect(Collectors.toList()));
    }

    public static ParamsApi5UpdateAds makeOnlyOneFieldChanged(final List<Ad> ad) {
        return new ParamsApi5UpdateAds().withAds(makeOneFieldChanged(ad).getAds().stream()
                .map(x -> x.withTextAd(new TextAd().withText(null)))
                        .collect(Collectors.toList()));
    }
    public static ParamsApi5UpdateAds makeOnlyOneAnotherFieldChanged(final List<Ad> ad) {
        ParamsApi5UpdateAds result = new ParamsApi5UpdateAds().withAds(makeOneFieldChanged(ad).getAds().stream()
                .map(x -> x.withTextAd(new TextAd().withText(null)))
                .collect(Collectors.toList()));
        result.getAds().get(0).getTextAd().withText("test").withTitle(null);
        return result;
    }

}
