package ru.yandex.autotests.mediaplan.exceptions;

/**
 * Changes by ginger on 17.02.16.
 * Exception, выбрасываемый в случае неожиданных ошибок, не связанных
 * непосредственно с тестовым сценарием. Например,
 * ошибки тестовой среды
 * ошибки в тестах
 */
public class DirectException  extends RuntimeException {
    String mistake = "Ошибка запроса к сервису";

    public DirectException() {
        super();             // call superclass constructor
        mistake = "unknown";
    }

    public DirectException(String err) {
        super(err);     // call super class constructor
        mistake = err;  // save message
    }

    public DirectException(String message, Throwable cause) {
        super(message, cause);
    }
}
