package ru.yandex.autotests.mediaplan.rules;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.AddResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.Api5AddAdgroupsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.ParamsApi5AddAdgroups;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Ad;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.ParamsApi5AddAds;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.Keyword;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.ParamsApi5AddSitelinks;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.ParamsApi5AddVcards;
import ru.yandex.autotests.mediaplan.rules.creators.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static ru.yandex.autotests.mediaplan.datafactories.AddAdGroupsFactory.oneAdgroup;

public class AdgroupRule extends MediaplanRule {
    protected List<Creator> creators;
    protected KeywordsCreator keywordsCreator;
    protected AdCreator adCreator;
    protected SitelinksCreator sitelinksCreator;
    protected VCardsCreator vcardsCreator;
    protected ParamsApi5AddAdgroups paramsApi5AddAdgroups;
    protected Api5AddAdgroupsResult api5AddAdgroupsResult;
    protected Long adGroupId;
    protected List<Long> adGroupIds;

    public AdgroupRule() {
        creators = new ArrayList<>();
    }

    @Override
    protected void start() {
        super.start();
        lastUpdateTimestamp = mediaplan.getAddResults().get(0).getTimestamp();

        api5AddAdgroupsResult = userSteps.adGroupsSteps().api5AdGroupsAdd(
                getParamsApi5AddAdgroups().withMediaplanId(mediaplanId).withTimestamp(lastUpdateTimestamp)
                        .withClientId(DEFAULT_CLIENT)
        );
        adGroupId = api5AddAdgroupsResult.getAddResults().get(0).getId();
        adGroupIds = api5AddAdgroupsResult.getAddResults().stream()
                .map(AddResult::getId)
                .collect(Collectors.toList());
        lastUpdateTimestamp = api5AddAdgroupsResult.getTimestamp();
        doCreate();
    }

    protected void doCreate(){
        creators.forEach(x -> {
            x.create();
            this.setLastUpdateTimestamp(x.getLastUpdateTimestamp());
        });
    }

    public AdgroupRule withAd(ParamsApi5AddAds paramsApi5AddAds) {
        adCreator = new AdCreator(this, paramsApi5AddAds);
        creators.add(adCreator);
        return this;
    }

    public AdgroupRule withKeywords(List<Keyword> keywords) {
        keywordsCreator = new KeywordsCreator(this, keywords);
        creators.add(keywordsCreator);
        return this;
    }

    public AdgroupRule withSitelinks(ParamsApi5AddSitelinks sitelinks) {
        sitelinksCreator = new SitelinksCreator(this, sitelinks);
        creators.add(sitelinksCreator);
        return this;
    }

    public List<Long> getSitelinksIds() {
        return sitelinksCreator.getIds();
    }

    public AdgroupRule withVCards(ParamsApi5AddVcards paramsApi5AddVcards) {
        vcardsCreator = new VCardsCreator(this, paramsApi5AddVcards);
        creators.add(vcardsCreator);
        return this;
    }

    public List<Long> getVCardeIds() {
        return vcardsCreator.getIds();
    }

    public List<Long> getAdIds() {
        return adCreator.getAdIds();
    }

    public List<Ad> getAds() {
        return adCreator.getAds();
    }


    public List<Long> getKeywordsIds() {
        return this.keywordsCreator.getKeywordIds();
    }

    public List<Long> getAdGroupIds() {
        return adGroupIds;
    }

    public void setAdGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
    }


    public List<Keyword>  getKeywords() {
        return this.keywordsCreator.getKeywords();
    }

    public ParamsApi5AddAdgroups getParamsApi5AddAdgroups() {
        if (paramsApi5AddAdgroups == null) {
            paramsApi5AddAdgroups = oneAdgroup();
        }
        return paramsApi5AddAdgroups;
    }

    public AdgroupRule withAddAdGroupsInputData(ParamsApi5AddAdgroups addAdGroupsInputData) {
        this.paramsApi5AddAdgroups = addAdGroupsInputData;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

}
