package ru.yandex.autotests.mediaplan.rules;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.AddResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.Api5AddMediaplansResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.Mediaplan;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.Api5AddRequestsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.ParamsApi5AddRequests;
import ru.yandex.autotests.mediaplan.steps.UserStepsMediaplan;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.mediaplan.datafactories.AddRequestsFactory.defaultAddRequestWithAuthorId;
import static ru.yandex.autotests.mediaplan.datafactories.ClientIdsFactory.getDefaultClientID;

public class MediaplanRule extends BaseRule {
    public static Long getClient() {
        return DEFAULT_CLIENT;
    }

    private Long requestId;

    protected static Long uid = getDefaultClientID();
    protected static final Long DEFAULT_CLIENT = getDefaultClientID();
    protected UserStepsMediaplan userSteps = new UserStepsMediaplan();
    protected Long mediaplanId;
    protected List<Long> mediaplanIds;
    protected List<Long> requestIds;
    protected Api5AddRequestsResult requestOutputData;
    protected Long lastUpdateTimestamp;
    protected ParamsApi5AddRequests paramsApi5AddRequests;
    protected List<Mediaplan> mediaplans;
    protected Api5AddMediaplansResult mediaplan;

    @Override
    protected void start() {
        createMediaplan();
    }

    public MediaplanRule() {
        paramsApi5AddRequests = defaultAddRequestWithAuthorId(uid);
    }

    protected void createMediaplan() {
        requestOutputData = userSteps.requestsSteps().api5RequestsAdd(paramsApi5AddRequests);
        assumeThat("вернулась одна заявка", requestOutputData.getAddResults().size(), equalTo(paramsApi5AddRequests.getRequests().size()));
        assumeThat("ошибок при создании заявки не получено", requestOutputData.getAddResults().get(0).getErrors(), hasSize(0));
        requestIds = requestOutputData.getAddResults().stream().map(x -> x.getId()).collect(Collectors.toList());
        requestId = requestOutputData.getAddResults().get(0).getId();
        for (int i = 0; i < getMediaplans().size(); i++) {
            getMediaplans().get(i).setRequestId(requestOutputData.getAddResults().get(i).getId());
        }
        mediaplan = userSteps.mediaplansSteps().api5MediaplansAdd(mediaplans);
        mediaplanId = mediaplan.getAddResults().get(0).getId();
        mediaplanIds = mediaplan.getAddResults().stream().map(AddResult::getId).collect(Collectors.toList());
        setLastUpdateTimestamp(mediaplan.getAddResults().get(mediaplan.getAddResults().size() - 1).getTimestamp());
    }

    public Api5AddMediaplansResult getMediaplan() {
        return mediaplan;
    }


    public void setMediaplan(Api5AddMediaplansResult mediaplan) {
        this.mediaplan = mediaplan;
    }

    public Long getLastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public Long getMediaplanId() {
        return mediaplanId;
    }

    public void setMediaplanId(Long mediaplanId) {
        this.mediaplanId = mediaplanId;
    }

    public UserStepsMediaplan getUserSteps() {
        return userSteps;
    }

    public void setUserSteps(UserStepsMediaplan userSteps) {
        this.userSteps = userSteps;
    }

    public static Long getUid() {
        return uid;
    }

    public static void setUid(Long uid) {
        MediaplanRule.uid = uid;
    }


    public Long getRequestId() {
        return requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public ParamsApi5AddRequests getParamsApi5AddRequests() {
        return paramsApi5AddRequests;
    }

    public void setParamsApi5AddRequests(ParamsApi5AddRequests paramsApi5AddRequests) {
        this.paramsApi5AddRequests = paramsApi5AddRequests;
    }

    public MediaplanRule withParamsApi5AddRequests(ParamsApi5AddRequests paramsApi5AddRequests) {
        this.paramsApi5AddRequests = paramsApi5AddRequests;
        return this;
    }

    public Api5AddRequestsResult getRequestOutputData() {
        return requestOutputData;
    }

    public List<Mediaplan> getMediaplans() {
        if (mediaplans == null) {
            mediaplans = Collections.singletonList(new Mediaplan()
                    .withMediaplannerUID(uid)
                    .withClientId(DEFAULT_CLIENT));
        }
        return mediaplans;
    }

    public void setMediaplans(List<Mediaplan> mediaplans) {
        this.mediaplans = mediaplans;
    }


    public MediaplanRule withMediaplans(List<Mediaplan> mediaplans) {
        this.mediaplans = mediaplans;
        return this;
    }

    public List<Long> getMediaplanIds() {
        return mediaplanIds;
    }

    public List<Long> getRequestIds() {
        return requestIds;
    }
}
