package ru.yandex.autotests.mediaplan.rules.creators;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Ad;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.AddResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Api5AddAdsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.ParamsApi5AddAds;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_changes_check_verbose.Api5ChangesCheckVerboseResult;
import ru.yandex.autotests.mediaplan.rules.AdgroupRule;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.mediaplan.rules.MediaplanRule.getClient;

public class AdCreator extends Creator {
    private Api5AddAdsResult addAdsResult;
    private ParamsApi5AddAds paramsApi5AddAds;

    private List<Ad> ads;

    public AdCreator(AdgroupRule adgroupRule, ParamsApi5AddAds paramsApi5AddAds) {
        super(adgroupRule);
        this.paramsApi5AddAds = paramsApi5AddAds;
    }

    @Override
    public void create() {
        paramsApi5AddAds.getAds().stream().map(x -> x.withAdGroupId(adgroupRule.getAdGroupId())).collect(Collectors.toList());
        addAdsResult = adgroupRule.getUserSteps().adsSteps().api5AdsAdd(
                paramsApi5AddAds
                        .withMediaplanId(adgroupRule.getMediaplanId())
                        .withClientId(getClient())
                        .withTimestamp(adgroupRule.getLastUpdateTimestamp()));
        List<Ad> expectedAds = IntStream.range(0, paramsApi5AddAds.getAds().size())
                .mapToObj(x -> paramsApi5AddAds.getAds().get(x).withId(addAdsResult.getAddResults().get(x).getId())).collect(Collectors.toList());
        Api5ChangesCheckVerboseResult changes = adgroupRule.getUserSteps().changesSteps()
                .adGroupChanges(adgroupRule.getAdGroupIds(), getClient(), adgroupRule.getMediaplanId());

        ads = changes.getModified().getAds();
        adgroupRule.setLastUpdateTimestamp(changes.getTimestamp());

        assumeThat("Сохраненные баннеры соотвествуют ожиданиям", changes.getModified().getAds(), equalTo(expectedAds));
    }

    public Api5AddAdsResult getAddAdsResult() {
        return addAdsResult;
    }

    public void setAddAdsResult(Api5AddAdsResult addAdsResult) {
        this.addAdsResult = addAdsResult;
    }

    public ParamsApi5AddAds getParamsApi5AddAds() {
        return paramsApi5AddAds;
    }

    public void setParamsApi5AddAds(ParamsApi5AddAds paramsApi5AddAds) {
        this.paramsApi5AddAds = paramsApi5AddAds;
    }

    public List<Long> getAdIds() {
        return addAdsResult.getAddResults().stream().map(AddResult::getId).collect(Collectors.toList());
    }

    public List<Ad> getAds() {
        return ads;
    }
}
