package ru.yandex.autotests.mediaplan.rules.creators;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.AddResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.Keyword;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.ParamsApi5AddKeywords;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_changes_check_verbose.Api5ChangesCheckVerboseResult;
import ru.yandex.autotests.mediaplan.rules.AdgroupRule;

import java.util.List;
import java.util.stream.Collectors;

import static ru.yandex.autotests.mediaplan.rules.MediaplanRule.getClient;

public class KeywordsCreator extends Creator {
    private List<Long> keywordIds;

    private List<Keyword> keywords;

    public KeywordsCreator(AdgroupRule adgroupRule, List<Keyword> keywords) {
        super(adgroupRule);
        this.keywords = keywords;
    }

    @Override
    public void create() {
        keywords.stream().map(x -> x.withAdGroupId(adgroupRule.getAdGroupId())).collect(Collectors.toList());
        keywordIds = adgroupRule.getUserSteps().keywordsSteps().api5KeywordsAdd(
                new ParamsApi5AddKeywords()
                        .withMediaplanId(adgroupRule.getMediaplanId())
                        .withClientId(getClient())
                        .withTimestamp(adgroupRule.getLastUpdateTimestamp())
                        .withKeywords(keywords))
                .getAddResults().stream().map(AddResult::getId).collect(Collectors.toList());
        Api5ChangesCheckVerboseResult changes = adgroupRule.getUserSteps().changesSteps()
                .adGroupChanges(adgroupRule.getAdGroupIds(), getClient(), adgroupRule.getMediaplanId());
        adgroupRule.setLastUpdateTimestamp(changes.getTimestamp());
    }

    public List<Keyword> getKeywords() {
        return keywords;
    }

    public List<Long> getKeywordIds() {
        return keywordIds;
    }

}
