package ru.yandex.autotests.mediaplan.rules.creators;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.AddResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.Api5AddSitelinksResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.ParamsApi5AddSitelinks;
import ru.yandex.autotests.mediaplan.rules.AdgroupRule;

import java.util.List;
import java.util.stream.Collectors;

import static ru.yandex.autotests.mediaplan.rules.MediaplanRule.getClient;

public class SitelinksCreator extends Creator {

    private ParamsApi5AddSitelinks paramsApi5AddSitelinks;

    private Api5AddSitelinksResult addResults;

    public SitelinksCreator(AdgroupRule adgroupRule, ParamsApi5AddSitelinks paramsApi5AddSitelinks) {
        super(adgroupRule);
        this.paramsApi5AddSitelinks = paramsApi5AddSitelinks;

    }

    @Override
    public void create() {
        addResults = adgroupRule.getUserSteps().sitelinksSteps().api5SitelinksAdd(paramsApi5AddSitelinks
                .withMediaplanId(adgroupRule.getMediaplanId())
                .withClientId(getClient())
                .withTimestamp(adgroupRule.getLastUpdateTimestamp()));
        adgroupRule.setLastUpdateTimestamp(addResults.getTimestamp());

    }
    public Api5AddSitelinksResult getAddResults() {
        return addResults;
    }

    public List<Long> getIds(){
        return addResults.getAddResults().stream().map(AddResult::getId).collect(Collectors.toList());
    }

}
