package ru.yandex.autotests.mediaplan.rules.creators;

import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.Api5AddVcardsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.ParamsApi5AddVcards;
import ru.yandex.autotests.mediaplan.rules.AdgroupRule;

import java.util.List;
import java.util.stream.Collectors;

import static ru.yandex.autotests.mediaplan.rules.MediaplanRule.getClient;

public class VCardsCreator extends Creator {
    private ParamsApi5AddVcards paramsApi5AddVcards;
    private Api5AddVcardsResult vcardsResult;

    public VCardsCreator(AdgroupRule adgroupRule, ParamsApi5AddVcards paramsApi5AddVcards) {
        super(adgroupRule);
        this.paramsApi5AddVcards = paramsApi5AddVcards;

    }
    @Override
    public void create() {
        vcardsResult = adgroupRule.getUserSteps().vcardsSteps().api5VcardsAdd(
                paramsApi5AddVcards
                        .withMediaplanId(adgroupRule.getMediaplanId())
                        .withClientId(getClient())
                        .withTimestamp(adgroupRule.getLastUpdateTimestamp())
        );
        adgroupRule.setLastUpdateTimestamp(vcardsResult.getTimestamp());
    }

    public Api5AddVcardsResult getVcardsResult() {
        return vcardsResult;
    }

    public List<Long> getIds() {
        return vcardsResult.getAddResults().stream().map(x->x.getId()).collect(Collectors.toList());
    }
}
