package ru.yandex.autotests.mediaplan.steps;

import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.autotests.mediaplan.client.ConnectionConfig;
import ru.yandex.autotests.mediaplan.steps.adgroups.AdGroupsStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.ads.AdsStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.bids.BidsStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.changes.ChangesStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.keywords.KeywordsStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.mediaplans.MediaplansStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.requests.RequestsStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.sitelinks.SitelinksStepsMediaplan;
import ru.yandex.autotests.mediaplan.steps.vcards.VcardsStepsMediaplan;

/**
 * Changes by ginger on 17.02.16.
 */
public class UserStepsMediaplan {
    public UserStepsMediaplan() {
        this.context = ConnectionConfig.getMediaplanDefaultConfig();
    }

    //region Sub-steps
    private ConnectionConfig context;

    public RequestsStepsMediaplan requestsSteps() {
        return BaseSteps.getInstance(RequestsStepsMediaplan.class, getContext());
    }

    public MediaplansStepsMediaplan mediaplansSteps() {
        return BaseSteps.getInstance(MediaplansStepsMediaplan.class, getContext());
    }

    public AdGroupsStepsMediaplan adGroupsSteps() {
        return BaseSteps.getInstance(AdGroupsStepsMediaplan.class, getContext());
    }

    public AdsStepsMediaplan adsSteps() {
        return BaseSteps.getInstance(AdsStepsMediaplan.class, getContext());
    }

    public BidsStepsMediaplan bidsSteps() {
        return BaseSteps.getInstance(BidsStepsMediaplan.class, getContext());
    }

    public ChangesStepsMediaplan changesSteps() {
        return BaseSteps.getInstance(ChangesStepsMediaplan.class, getContext());
    }

    public KeywordsStepsMediaplan keywordsSteps() {
        return BaseSteps.getInstance(KeywordsStepsMediaplan.class, getContext());
    }

    public SitelinksStepsMediaplan sitelinksSteps() {
        return BaseSteps.getInstance(SitelinksStepsMediaplan.class, getContext());
    }

    public VcardsStepsMediaplan vcardsSteps() {
        return BaseSteps.getInstance(VcardsStepsMediaplan.class, getContext());
    }

    public ConnectionConfig getContext() {
        return context;
    }

    public void setContext(ConnectionConfig context) {
        this.context = context;
    }
}
