package ru.yandex.autotests.mediaplan.steps.adgroups;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.AdGroup;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.Api5AddAdgroupsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.ParamsApi5AddAdgroups;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_adgroups.Api5DeleteAdgroupsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_adgroups.ParamsApi5DeleteAdgroups;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_adgroups.SelectionCriteria;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_adgroups.Api5UpdateAdgroupsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_adgroups.ParamsApi5UpdateAdgroups;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Collections;
import java.util.List;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Changes by ginger on 17.02.16.
 */
public class AdGroupsStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_adgroups]: Delete")
    public Api5DeleteAdgroupsResult api5AdGroupsDelete(ParamsApi5DeleteAdgroups parameters) {
        return jsonClient().invokeMethod(ServiceNames.AD_GROUPS, Action.DELETE, parameters);
    }

    @Step("[api5_adgroups]: Delete")
    public Api5DeleteAdgroupsResult api5AdGroupsDelete(Long mediaplanId, Long timestamp, Long adGroupId) {
       return api5AdGroupsDelete(
                new ParamsApi5DeleteAdgroups()
                        .withTimestamp(timestamp)
                        .withSelectionCriteria(
                                new SelectionCriteria().withIds(Collections.singletonList(adGroupId))
                        )
                        .withMediaplanId(mediaplanId)
        );
    }


    @Step("[api5_adgroups]: Add")
    public Api5AddAdgroupsResult api5AdGroupsAdd(ParamsApi5AddAdgroups parameters) {
        return jsonClient().invokeMethod(ServiceNames.AD_GROUPS, Action.ADD, parameters);
    }

    @Step("[api5_adgroups]: Add")
    public Api5AddAdgroupsResult api5AdGroupsAdd(Long mediaplanId, Long timestamp, List<AdGroup> items) {
        return api5AdGroupsAdd(
                new ParamsApi5AddAdgroups()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withAdGroups(items));
    }

    @Step("[api5_adgroups]: Add")
    public Api5AddAdgroupsResult api5AdGroupsAddOneItem(Long mediaplanId, Long timestamp, AdGroup item) {
        Api5AddAdgroupsResult adGroupsOutputData = api5AdGroupsAdd(mediaplanId, timestamp, Collections.singletonList(item));
        assumeThat("получена группа", adGroupsOutputData.getAddResults(), hasSize(1));
        assumeThat("получен Id группы", adGroupsOutputData.getAddResults().get(0).getId(), equalTo(1));
        return adGroupsOutputData;
    }

    @Step("[api5_adgroups]: Update")
    public Api5UpdateAdgroupsResult api5AdGroupsUpdate(ParamsApi5UpdateAdgroups parameters) {
        return jsonClient().invokeMethod(ServiceNames.AD_GROUPS, Action.UPDATE, parameters);
    }

    @Step("[api5_adgroups]: Update")
    public Api5UpdateAdgroupsResult api5AdGroupsUpdate(Long mediaplanId, Long timestamp, List<AdGroup> items) {
        return api5AdGroupsUpdate(
                new ParamsApi5UpdateAdgroups()
                    .withMediaplanId(mediaplanId)
                    .withTimestamp(timestamp)
                    .withAdGroups(items)
        );
    }
}
