package ru.yandex.autotests.mediaplan.steps.ads;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Ad;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Api5AddAdsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.ParamsApi5AddAds;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_ads.Api5DeleteAdsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_ads.ParamsApi5DeleteAds;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_ads.SelectionCriteria;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_ads.Api5UpdateAdsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_ads.ParamsApi5UpdateAds;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

/**
 * Changes by ginger on 17.02.16.
 */
public class AdsStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_ads]: Delete")
    public Api5DeleteAdsResult api5AdsDelete(ParamsApi5DeleteAds parameters) {
        return jsonClient().invokeMethod(ServiceNames.ADS, Action.DELETE, parameters);
    }

    @Step("[api5_ads]: Delete")
    public Api5DeleteAdsResult api5AdsDelete(Long mediaplanId, Long timestamp, SelectionCriteria selectionCriteria) {
        return api5AdsDelete(
                new ParamsApi5DeleteAds()
                        .withTimestamp(timestamp)
                        .withMediaplanId(mediaplanId)
                        .withSelectionCriteria(selectionCriteria)
        );
    }

    @Step("[api5_ads]: Add")
    public Api5AddAdsResult api5AdsAdd(ParamsApi5AddAds parameters) {
        return jsonClient().invokeMethod(ServiceNames.ADS, Action.ADD, parameters);
    }

    @Step("[api5_ads]: Add")
    public Api5AddAdsResult api5AdsAdd(Long mediaplanId, Long timestamp,List<Ad> items) {
        return api5AdsAdd(
                new ParamsApi5AddAds()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withAds(items));
    }

    @Step("[api5_ads]: Update")
    public Api5UpdateAdsResult api5AdsUpdate(ParamsApi5UpdateAds parameters) {
        return jsonClient().invokeMethod(ServiceNames.ADS, Action.UPDATE, parameters);
    }

    @Step("[api5_ads]: Update")
    public Api5UpdateAdsResult api5AdsUpdate(Long mediaplanId, Long timestamp, List<Ad> items) {
        return api5AdsUpdate(
                new ParamsApi5UpdateAds()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withAds(items)
        );
    }
}