package ru.yandex.autotests.mediaplan.steps.changes;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_changes_check_verbose.Api5ChangesCheckVerboseResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_changes_check_verbose.ParamsApi5ChangesCheckVerbose;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

/**
 * Changes by ginger on 17.02.16.
 */
public class ChangesStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_changes]: CheckVerbose")
    public Api5ChangesCheckVerboseResult api5ChangesCheckVerbose(ParamsApi5ChangesCheckVerbose parameters) {
        return jsonClient().invokeMethod(ServiceNames.CHANGES, Action.CHECK_VERBOSE, parameters);
    }

    @Step("[api5_changes]: CheckVerbose")
    public Api5ChangesCheckVerboseResult adGroupChanges(List<Long> adGroupId, Long clientId, Long mediaplanId) {
        ParamsApi5ChangesCheckVerbose parameters = new ParamsApi5ChangesCheckVerbose()
                .withAdGroupIds(adGroupId)
                .withClientId(clientId)
                .withMediaplanId(mediaplanId)
                .withTimestamp(0l);
        return api5ChangesCheckVerbose(parameters);
    }

    @Step("[api5_changes]: CheckVerbose")
    public Api5ChangesCheckVerboseResult adGroupChanges(List<Long> adGroupId, Long clientId, Long mediaplanId, Long timeStamp) {
        ParamsApi5ChangesCheckVerbose parameters = new ParamsApi5ChangesCheckVerbose()
                .withAdGroupIds(adGroupId)
                .withClientId(clientId)
                .withMediaplanId(mediaplanId)
                .withTimestamp(timeStamp);
        return api5ChangesCheckVerbose(parameters);
    }

}
