package ru.yandex.autotests.mediaplan.steps.keywords;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.Api5AddKeywordsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.Keyword;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_keywords.ParamsApi5AddKeywords;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_keywords.Api5DeleteKeywordsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_keywords.ParamsApi5DeleteKeywords;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_keywords.SelectionCriteria;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_forecast_keywords.Api5ForecastKeywordsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_forecast_keywords.ParamsApi5ForecastKeywords;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_predict_reset_ctr_keywords.Api5PredictResetCtrKeywordsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_predict_reset_ctr_keywords.ParamsApi5PredictResetCtrKeywords;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_keywords.Api5UpdateKeywordsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_update_keywords.ParamsApi5UpdateKeywords;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

/**
 * Changes by ginger on 17.02.16.
 */
public class KeywordsStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_keywords]: Add")
    public Api5AddKeywordsResult api5KeywordsAdd(ParamsApi5AddKeywords parameters) {
        return jsonClient().invokeMethod(ServiceNames.KEYWORDS, Action.ADD, parameters);
    }

    @Step("[api5_keywords]: Add")
    public Api5AddKeywordsResult api5KeywordsAdd(Long mediaplanId, Long timestamp, List<Keyword> items) {
        return api5KeywordsAdd(
                new ParamsApi5AddKeywords()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withKeywords(items)
        );
    }

    @Step("[api5_keywords]: Update")
    public Api5UpdateKeywordsResult api5KeywordsUpdate(ParamsApi5UpdateKeywords parameters) {
        return jsonClient().invokeMethod(ServiceNames.KEYWORDS, Action.UPDATE, parameters);
    }

    @Step("[api5_keywords]: Update")
    public Api5UpdateKeywordsResult api5KeywordsUpdate(Long mediaplanId, Long timestamp, List<Keyword> items) {
        return api5KeywordsUpdate(
                new ParamsApi5UpdateKeywords()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withKeywords(items)
        );
    }

    @Step("[api5_keywords]: Delete")
    public Api5DeleteKeywordsResult api5KeywordsDelete(ParamsApi5DeleteKeywords parameters) {
        return jsonClient().invokeMethod(ServiceNames.KEYWORDS, Action.DELETE, parameters);
    }

    @Step("[api5_keywords]: Delete")
    public Api5DeleteKeywordsResult api5KeywordsDelete(Long mediaplanId, Long timestamp, SelectionCriteria selectionCriteria) {
        return api5KeywordsDelete(
                new ParamsApi5DeleteKeywords()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withSelectionCriteria(selectionCriteria)
        );
    }

    @Step("[api5_keywords]: Forecast")
    public Api5ForecastKeywordsResult api5KeywordsForecast(ParamsApi5ForecastKeywords parameters) {
        return jsonClient().invokeMethod(ServiceNames.KEYWORDS, Action.FORECAST, parameters);
    }
    @Step("[api5_keywords]: Forecast")
    public Api5ForecastKeywordsResult api5KeywordsForecast(Long mediaplanId, Long timestamp, List<Keyword> items) {
        return api5KeywordsForecast(
                new ParamsApi5ForecastKeywords()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withKeywords(items)
        );
    }

    @Step("[api5_predict_reset_ctr_keywords]: Forecast")
    public Api5PredictResetCtrKeywordsResult api5KeywordsPredictResetCtrKeywords(ParamsApi5PredictResetCtrKeywords parameters) {
        return jsonClient().invokeMethod(ServiceNames.KEYWORDS, Action.PREDICT_RESET_CTR, parameters);
    }
}