package ru.yandex.autotests.mediaplan.steps.mediaplans;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.Api5AddMediaplansResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.Mediaplan;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_mediaplans.ParamsApi5AddMediaplans;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_get_mediaplans.Api5GetMediaplansResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_get_mediaplans.ParamsApi5GetMediaplans;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_get_mediaplans.SelectionCriteria;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Collections;
import java.util.List;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Changes by ginger on 17.02.16.
 */
public class MediaplansStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_mediaplans]: Get")
    public Api5GetMediaplansResult api5MediaplansGet(ParamsApi5GetMediaplans parameters) {
        return jsonClient().invokeMethod(ServiceNames.MEDIAPLANS, Action.GET, parameters);
    }

    @Step("[api5_mediaplans]: Get")
    public Api5GetMediaplansResult api5MediaplansGet(SelectionCriteria selectionCriteria) {
        return jsonClient().invokeMethod(ServiceNames.MEDIAPLANS, Action.GET,
                new ParamsApi5GetMediaplans()
                        .withSelectionCriteria(selectionCriteria));
    }
    @Step("[api5_mediaplans]: Get")
    public Api5GetMediaplansResult api5MediaplansGetByIds(List<Long> ids) {
        return jsonClient().invokeMethod(ServiceNames.MEDIAPLANS, Action.GET,
                new ParamsApi5GetMediaplans()
                        .withSelectionCriteria(
                                new SelectionCriteria()
                                    .withIds(ids)
                        ));
    }
    @Step("[api5_mediaplans]: Get")
    public Api5GetMediaplansResult api5MediaplansGetByMediaplannerUID(Long uid) {
        return jsonClient().invokeMethod(ServiceNames.MEDIAPLANS, Action.GET,
                new ParamsApi5GetMediaplans()
                        .withSelectionCriteria(
                                new SelectionCriteria()
                                        .withMediaplannerUID(uid)
                        ));
    }

    @Step("[api5_mediaplans]: Get")
    public Api5GetMediaplansResult api5MediaplansGetByRequestID(Long requestId) {
        return jsonClient().invokeMethod(ServiceNames.MEDIAPLANS, Action.GET,
                new ParamsApi5GetMediaplans()
                        .withSelectionCriteria(
                                new SelectionCriteria()
                                        .withRequestID(requestId)
                        ));
    }

    @Step("[api5_mediaplans]: Add")
    public Api5AddMediaplansResult api5MediaplansAdd(ParamsApi5AddMediaplans parameters) {
        return jsonClient().invokeMethod(ServiceNames.MEDIAPLANS, Action.ADD, parameters);
    }

    @Step("[api5_mediaplans]: Add")
    public Api5AddMediaplansResult api5MediaplansAdd(List<Mediaplan> items) {
        return api5MediaplansAdd(
                new ParamsApi5AddMediaplans()
                        .withMediaplans(items));
    }

    @Step("[api5_mediaplans]: Add")
    public Api5AddMediaplansResult api5MediaplansAdd(Mediaplan item) {
        Api5AddMediaplansResult mediaplansOutputData = api5MediaplansAdd(
                new ParamsApi5AddMediaplans()
                        .withMediaplans(Collections.singletonList(item)));
        assumeThat("получены медиапланы", mediaplansOutputData.getAddResults().size(), equalTo(1));
        return mediaplansOutputData;
    }
}
