package ru.yandex.autotests.mediaplan.steps.requests;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.Api5AddRequestsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.ParamsApi5AddRequests;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_requests.Request;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_get_requests.Api5GetRequestsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_get_requests.ParamsApi5GetRequests;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_get_requests.SelectionCriteria;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Collections;
import java.util.List;

/**
 * Changes by ginger on 17.02.16.
 */
public class RequestsStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_requests]: Get")
    public Api5GetRequestsResult api5RequestsGet(ParamsApi5GetRequests parameters) {
        return jsonClient().invokeMethod(ServiceNames.REQUESTS, Action.GET, parameters);
    }

    @Step("[api5_requests]: Get")
    public Api5GetRequestsResult api5RequestsGet(SelectionCriteria selectionCriteria) {
        return jsonClient().invokeMethod(ServiceNames.REQUESTS, Action.GET,
                new ParamsApi5GetRequests().withSelectionCriteria(selectionCriteria));
    }

    @Step("[api5_requests]: Get")
    public Api5GetRequestsResult api5RequestsGetByIds(List<Long> ids) {
        return jsonClient().invokeMethod(ServiceNames.REQUESTS, Action.GET,
                new ParamsApi5GetRequests().withSelectionCriteria(
                        new SelectionCriteria()
                                .withIds(ids)
                ));
    }

    @Step("[api5_requests]: Get")
    public Api5GetRequestsResult api5RequestsGetByUID(Long uid) {
        return jsonClient().invokeMethod(ServiceNames.REQUESTS, Action.GET,
                new ParamsApi5GetRequests().withSelectionCriteria(
                        new SelectionCriteria()
                                .withMediaplannerUID(uid)
                ));
    }

    @Step("[api5_requests]: Add")
    public Api5AddRequestsResult api5RequestsAdd(ParamsApi5AddRequests parameters) {
        return jsonClient().invokeMethod(ServiceNames.REQUESTS, Action.ADD, parameters);
    }

    @Step("[api5_requests]: Add")
    public Api5AddRequestsResult api5RequestsAdd(List<Request> items) {
        return api5RequestsAdd(
                new ParamsApi5AddRequests()
                        .withRequests(items));
    }

    @Step("[api5_requests]: Add")
    public Api5AddRequestsResult  api5RequestsAdd(Request item) {
        return api5RequestsAdd(
                new ParamsApi5AddRequests()
                        .withRequests(Collections.singletonList(item)));
    }

}