package ru.yandex.autotests.mediaplan.steps.sitelinks;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.Api5AddSitelinksResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.ParamsApi5AddSitelinks;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_sitelinks.SitelinksSet;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_sitelinks.Api5DeleteSitelinksResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_sitelinks.ParamsApi5DeleteSitelinks;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_sitelinks.SelectionCriteria;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

/**
 * Changes by ginger on 18.02.16.
 */
public class SitelinksStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_sitelinks]: Delete")
    public Api5DeleteSitelinksResult api5SitelinksDelete(Long mediaplanId, Long timestamp, SelectionCriteria ids) {
        return api5SitelinksDelete(
                new ParamsApi5DeleteSitelinks()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withSelectionCriteria(ids)
        );
    }

    @Step("[api5_sitelinks]: Delete")
    public Api5DeleteSitelinksResult api5SitelinksDelete(ParamsApi5DeleteSitelinks parameters) {
        return jsonClient().invokeMethod(ServiceNames.SITELINKS, Action.DELETE, parameters);
    }

    @Step("[api5_sitelinks]: Add")
    public Api5AddSitelinksResult api5SitelinksAdd(ParamsApi5AddSitelinks parameters) {
        return jsonClient().invokeMethod(ServiceNames.SITELINKS, Action.ADD, parameters);
    }

    @Step("[api5_sitelinks]: Add")
    public Api5AddSitelinksResult api5SitelinksAdd(Long mediaplanId, Long timestamp, List<SitelinksSet> items) {
        return api5SitelinksAdd(
                new ParamsApi5AddSitelinks()
                    .withMediaplanId(mediaplanId)
                    .withTimestamp(timestamp)
                    .withSitelinksSets(items)
        );
    }
}
