package ru.yandex.autotests.mediaplan.steps.vcards;

import ru.yandex.autotests.mediaplan.client.Action;
import ru.yandex.autotests.mediaplan.client.ServiceNames;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.Api5AddVcardsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.ParamsApi5AddVcards;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_vcards.VCard;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_vcards.Api5DeleteVcardsResult;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_vcards.ParamsApi5DeleteVcards;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_delete_vcards.SelectionCriteria;
import ru.yandex.autotests.mediaplan.steps.MediaplanBaseSteps;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

/**
 * Changes by ginger on 17.02.16.
 */
public class VcardsStepsMediaplan extends MediaplanBaseSteps {
    @Step("[api5_vcards]: Add")
    public Api5AddVcardsResult api5VcardsAdd(ParamsApi5AddVcards parameters) {
        return jsonClient().invokeMethod(ServiceNames.VCARDS, Action.ADD, parameters);
    }

    @Step("[api5_vcards]: Add")
    public Api5AddVcardsResult api5VcardsAdd(Long mediaplanId, Long timestamp, List<VCard> items) {
        return api5VcardsAdd(
                new ParamsApi5AddVcards().withMediaplanId(mediaplanId).withTimestamp(timestamp).withVCards(items)
        );
    }

    @Step("[api5_vcards]: Delete")
    public Api5DeleteVcardsResult api5VcardsDelete(ParamsApi5DeleteVcards parameters) {
        return jsonClient().invokeMethod(ServiceNames.VCARDS, Action.DELETE, parameters);
    }

    @Step("[api5_vcards]: Delete")
    public Api5DeleteVcardsResult api5VcardsDelete(Long mediaplanId, Long timestamp, List<Long> ids) {
        return api5VcardsDelete(
                new ParamsApi5DeleteVcards()
                        .withMediaplanId(mediaplanId)
                        .withTimestamp(timestamp)
                        .withSelectionCriteria(new SelectionCriteria().withIds(ids))
        );
    }
}
