package ru.yandex.autotests.direct.scriptrunner.service.clientdata;

import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptParams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientDataParams extends ScriptParams {

    private static final String CID = "--cid";
    private static final String SHARD_ID = "--shard-id";
    private static final String PAR_ID = "--par-id";
    private static final String NO_SEND = "--no-send";
    private static final String FAKE_BS = "--fake-bs";
    private static final String ONCE = "--once";
    private static final String CLEAR_ALL = "--clear-all";
    private static final String FAKE_BS_URL_DATA = "--fake-bs-url-data";
    private static final String FAKE_BS_URL_PRICES = "--fake-bs-url-prices";
    private static final String NO_AUTO_BUGGY = "--no-auto-buggy";
    private static final String PREPROD = "--preprod";
    private static final String DISABLE_PREPROD_SPLIT = "--disable-preprod-split";
    private static final String NO_LOGBROKER = "--no-logbroker";

    public ClientDataParams() {
        super();
    }

    public ClientDataParams(ClientDataParams objectToClone) {
        super(objectToClone);
    }

    public List<Integer> getCid() {
        List<String> cidList = (List<String>) params.get(CID);
        if (cidList == null) {
            return null;
        }
        return cidList.stream().mapToInt(Integer::valueOf)
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public void setCid(List<Integer> cidList) {
        if (cidList != null) {
            params.put(CID, cidList.stream().map(String::valueOf)
                    .collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
        } else {
            params.remove(CID);
        }
    }

    public void setCid(Integer cid) {
        if (cid != null) {
            params.put(CID, Collections.singletonList(cid.toString()));
        } else {
            params.remove(CID);
        }
    }

    public Integer getShardId() {
        String shardId = null;
        if (params.get(SHARD_ID) != null) {
            shardId = (String) params.get(SHARD_ID);
        }
        return shardId == null ? null : Integer.valueOf(shardId);
    }

    public void setShardId(Integer shardId) {
        if (shardId != null) {
            params.put(SHARD_ID, String.valueOf(shardId));
        } else {
            params.remove(SHARD_ID);
        }
    }

    public String getParId() {
        String parId = null;
        if (params.get(PAR_ID) != null) {
            parId = (String) params.get(PAR_ID);
        }
        return parId == null ? null : parId;
    }

    public void setParId(String parId) {
        if (parId != null) {
            params.put(PAR_ID, parId);
        } else {
            params.remove(PAR_ID);
        }
    }

    public void setFakeBSUrlData(String fakeBSUrlData) {
        if (fakeBSUrlData != null) {
            params.put(FAKE_BS_URL_DATA, fakeBSUrlData);
        } else {
            params.remove(FAKE_BS_URL_DATA);
        }
    }

    public String getFakeBSUrlData() {
        String fakeBSUrlData = null;
        if (params.get(FAKE_BS_URL_DATA) != null) {
            fakeBSUrlData = (String) params.get(FAKE_BS_URL_DATA);
        }
        return fakeBSUrlData == null ? null : fakeBSUrlData;
    }

    public void setFakeBSUrlPrices(String fakeBSUrlPrices) {
        if (fakeBSUrlPrices != null) {
            params.put(FAKE_BS_URL_PRICES, fakeBSUrlPrices);
        } else {
            params.remove(FAKE_BS_URL_PRICES);
        }
    }

    public String getFakeBSUrlPrices() {
        String fakeBSUrlPrices = null;
        if (params.get(FAKE_BS_URL_PRICES) != null) {
            fakeBSUrlPrices = (String) params.get(FAKE_BS_URL_PRICES);
        }
        return fakeBSUrlPrices == null ? null : fakeBSUrlPrices;
    }

    public void setNoAutoBuggy(boolean noAutoBuggy) {
        setBoolVariable(NO_AUTO_BUGGY, noAutoBuggy);
    }

    public boolean isNoAutoBuggy() {
        return params.containsKey(NO_AUTO_BUGGY);
    }

    public boolean isOnce() {
        return params.containsKey(ONCE);
    }

    public void setOnce(boolean once) {
        setBoolVariable(ONCE, once);
    }

    public boolean isNoSend() {
        return params.containsKey(NO_SEND);
    }

    public void setNoSend(boolean noSend) {
        setBoolVariable(NO_SEND, noSend);
    }

    public boolean isFakeBs() {
        return params.containsKey(FAKE_BS);
    }

    public void setFakeBs(boolean fakeBs) {
        setBoolVariable(FAKE_BS, fakeBs);
    }

    public boolean isClearAll() {
        return params.containsKey(CLEAR_ALL);
    }

    public void setClearAll(boolean clearAll) {
        setBoolVariable(CLEAR_ALL, clearAll);
    }

    public boolean isPreprod() {
        return params.containsKey(PREPROD);
    }

    public boolean isDisablePreprodSplit() {
        return params.containsKey(DISABLE_PREPROD_SPLIT);
    }

    public void setPreprod(boolean preprod) {
        setBoolVariable(PREPROD, preprod);
    }

    public void setDisablePreprodSplit(boolean disablePreprodSplit) {
        setBoolVariable(DISABLE_PREPROD_SPLIT, disablePreprodSplit);
    }

    public ClientDataParams withCid(List<Integer> cidList) {
        this.setCid(cidList);
        return this;
    }

    public ClientDataParams withCid(Integer cid) {
        this.setCid(cid);
        return this;
    }

    public ClientDataParams withShardId(Integer shardId) {
        this.setShardId(shardId);
        return this;
    }

    public ClientDataParams withParId(String parId) {
        this.setParId(parId);
        return this;
    }

    public ClientDataParams withOnce(boolean once) {
        this.setOnce(once);
        return this;
    }

    public ClientDataParams withNoSend(boolean noSend) {
        this.setNoSend(noSend);
        return this;
    }

    public ClientDataParams withFakeBs(boolean fakeBs) {
        this.setFakeBs(fakeBs);
        return this;
    }

    public ClientDataParams withClearAll(boolean clearAll) {
        this.setClearAll(clearAll);
        return this;
    }

    public ClientDataParams withPreprod(boolean preprod) {
        this.setPreprod(preprod);
        return this;
    }

    public ClientDataParams withDisablePreprodSplit(boolean disablePreprodSplit) {
        this.setDisablePreprodSplit(disablePreprodSplit);
        return this;
    }

    public ClientDataParams withFakeBSUrlData(String fakeBSUrlData) {
        this.setFakeBSUrlData(fakeBSUrlData);
        return this;
    }

    public ClientDataParams withFakeBSUrlPrices(String fakeBSUrlPrices) {
        this.setFakeBSUrlPrices(fakeBSUrlPrices);
        return this;
    }

    public ClientDataParams withNoAutoBuggy(boolean noAutoBuggy) {
        this.setNoAutoBuggy(noAutoBuggy);
        return this;
    }

    public void setNoLogbroker(boolean noLogbroker) {
        setBoolVariable(NO_LOGBROKER, noLogbroker);
    }

    public boolean isNoLogbroker() {
        return params.containsKey(NO_LOGBROKER);
    }

    public ClientDataParams withNoLogbroker(boolean noLogbroker) {
        this.setNoLogbroker(noLogbroker);
        return this;
    }
}
