package ru.yandex.autotests.direct.scriptrunner.service.exportmaster;

import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptParams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExportMasterParams extends ScriptParams {

    private static String CID = "--cid";
    private static String SHARD_ID = "--shard-id";
    private static String ONCE = "--once";
    private static String NO_RESYNC = "--no-resync";

    public List<Integer> getCid() {
        List<String> cidList = (List<String>) params.get(CID);
        if(cidList == null){
            return null;
        }
        return cidList.stream().mapToInt(Integer::valueOf)
                .collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public void setCid(List<Integer> cidList) {
        if (cidList != null) {
            params.put(CID, cidList.stream().map(String::valueOf)
                    .collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
        } else {
            params.remove(CID);
        }
    }

    public void setCid(Integer cid) {
        if (cid != null) {
            params.put(CID, Collections.singletonList(cid.toString()));
        } else {
            params.remove(CID);
        }
    }

    public Integer getShardId() {
        String shardId = null;
        if (params.get(SHARD_ID) != null){
            shardId = (String) params.get(SHARD_ID);
        }
        return shardId == null ? null : Integer.valueOf(shardId);
    }

    public void setShardId(Integer shardId) {
        if (shardId != null) {
            params.put(SHARD_ID, String.valueOf(shardId));
        } else {
            params.remove(SHARD_ID);
        }
    }

    public boolean isOnce() {
        return params.containsKey(ONCE);
    }

    public void setOnce(boolean once) {
        setBoolVariable(ONCE, once);
    }

    public boolean isNoResync() {
        return params.containsKey(NO_RESYNC);
    }

    public void setNoResync(boolean noResync) {
        setBoolVariable(NO_RESYNC, noResync);
    }


    public ExportMasterParams withCid(List<Integer> cidList) {
        this.setCid(cidList);
        return this;
    }

    public ExportMasterParams withCid(Integer cid) {
        this.setCid(cid);
        return this;
    }


    public ExportMasterParams withShardId(Integer shardId) {
        this.setShardId(shardId);
        return this;
    }

    public ExportMasterParams withOnce(boolean once) {
        this.setOnce(once);
        return this;
    }

    public ExportMasterParams withNoResync(boolean noResync) {
        this.setNoResync(noResync);
        return this;
    }
}
