package ru.yandex.autotests.direct.scriptrunner.service.scripts;

public class ScriptDBConfig {

    private String dbHost;
    private int shardId;

    public ScriptDBConfig(String dbHost, int shardId) {
        this.dbHost = dbHost;
        this.shardId = shardId;
    }

    public String getDbHost() {
        return dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public int getShardId() {
        return shardId;
    }

    public void setShardId(int shardId) {
        this.shardId = shardId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptDBConfig)) {
            return false;
        }

        ScriptDBConfig dbConfig = (ScriptDBConfig) o;

        if (shardId != dbConfig.shardId) {
            return false;
        }

        return !(dbHost != null ? !dbHost.equals(dbConfig.dbHost) : dbConfig.dbHost != null);

    }

    @Override
    public int hashCode() {
        int result = dbHost != null ? dbHost.hashCode() : 0;
        result = 31 * result + shardId;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DbConfig: {");
        sb.append(" dbHost: ").append(dbHost).append(",");
        sb.append(" shardId: ").append(shardId);
        sb.append('}');
        return sb.toString();

    }
}
