package ru.yandex.autotests.direct.scriptrunner.service.scripts;

public class ScriptRunParams {

    private String host;
    private ScriptParams scriptParams;

    public ScriptRunParams(ScriptRunParams params) {
        this.host = params.host;
        this.scriptParams = new ScriptParams(params.getScriptParams());
    }

    public ScriptRunParams(String host, ScriptParams scriptParams) {
        if (host == null) {
            throw new IllegalArgumentException("parameter host must not be null");
        }
        if (scriptParams == null) {
            throw new IllegalArgumentException("parameter scriptParams must not be null");
        }
        this.host = host;
        this.scriptParams = scriptParams;
    }

    public String getHost() {
        return host;
    }

    public ScriptParams getScriptParams() {
        return scriptParams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ScriptRunParams that = (ScriptRunParams) o;

        return scriptParams.equals(that.scriptParams) && host.equals(that.host);

    }

    @Override
    public int hashCode() {
        int result = host.hashCode();
        result = 31 * result + scriptParams.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ScriptRunParams: {");
        sb.append(" host: ").append(host).append(",");
        sb.append(" runParams: {").append(scriptParams).append('}');
        sb.append('}');
        return sb.toString();
    }
}
