package ru.yandex.autotests.direct.scriptrunner.rest.providers;

import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class DefaultExceptionMapper implements ExceptionMapper<Throwable> {

    public Response toResponse(Throwable t) {
        return Response
                .status(500)
                .entity(ExceptionUtils.getStackTrace(t))
                .build();
    }
}
