package ru.yandex.autotests.direct.scriptrunner.rest.resources;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autotests.direct.scriptrunner.service.clientdata.ClientDataService;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunResult;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunTask;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.Scripts;

import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Component
@Singleton
@Path("scripts/" + Scripts.BS_CLIENT_DATA)
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class ClientDataRestService {

    @Autowired
    private ClientDataService clientDataService;

    @POST
    public ScriptRunResult runBsExportMaster(ScriptRunTask scriptRunTask) {
        return clientDataService.runBsClientData(scriptRunTask);
    }
}
