package ru.yandex.autotests.direct.scriptrunner.rest.resources;

import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autotests.direct.scriptrunner.service.exportmaster.ExportMasterService;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunResult;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptRunTask;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.Scripts;

@Component
@Singleton
@Path("scripts/" + Scripts.BS_EXPORT_MASTER)
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class ExportMasterRestService {

    @Autowired
    private ExportMasterService exportMasterService;

    @POST
    public ScriptRunResult runBsExportMaster(ScriptRunTask scriptRunTask) {
        return exportMasterService.runBsExportMaster(scriptRunTask);
    }

}
