package ru.yandex.autotests.direct.scriptrunner.service.bslogs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.JsonRpcLogExtractor;
import ru.yandex.autotests.direct.scriptrunner.service.scripts.ScriptrunnerServerException;
import ru.yandex.autotests.direct.scriptrunner.service.utils.Environments;

import java.net.URI;

@Service
public class BsLogsService {

    private static Gson gson = new GsonBuilder()
            .serializeNulls()
            .setPrettyPrinting()
            .create();

    public String getBsLogs(String betaHost, String date, String method, int shard, String... uuid) {
        try {
            URI jsonRpcServiceUrl = Environments.getJsonRpcServiceUrl(betaHost);
            JsonRpcLogExtractor logExtractor = new JsonRpcLogExtractor(jsonRpcServiceUrl);
            return gson.toJson(logExtractor.getBsLogs(date, shard, method, uuid));
        } catch (Exception e) {
            throw new ScriptrunnerServerException("error while getting bs logs", e);
        }
    }
}
