package ru.yandex.autotests.direct.scriptrunner.service.clientdata;

public class ParId {

    private String name;
    private int number;

    public ParId(String parId) {
        if (parId == null) {
            throw new IllegalArgumentException("par-id is null");
        }
        String[] parts = parId.split(":");
        if (parts.length != 2 || parts[0].length() == 0 || parts[1].length() == 0) {
            throw new IllegalArgumentException("invalid par-id: " + parId);
        }
        name = parts[0];
        try {
            number = Integer.parseInt(parts[1]);
        } catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid par-id: " + parId);
        }
    }

    public String getName() {
        return name;
    }

    public int getNumber() {
        return number;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ParId parId = (ParId) o;

        if (number != parId.number) return false;
        if (!name.equals(parId.name)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + number;
        return result;
    }

    @Override
    public String toString() {
        return name + ":" + number;
    }
}
