package ru.yandex.autotests.direct.scriptrunner.service.scripts;

import ru.yandex.autotests.direct.scriptrunner.service.scripts.clients.IntapiJsonRpcClient;

import java.net.URI;
import java.util.Map;

public class JsonRpcLogExtractor {

    private static final String SERVICE_NAME = "FakeAdmin";

    private BSLogsService service;

    public JsonRpcLogExtractor(URI jsonRpcUrl) {
        IntapiJsonRpcClient client = new IntapiJsonRpcClient(jsonRpcUrl, 30000);
        service = client.getServiceWithNamedParams(SERVICE_NAME, BSLogsService.class);
    }

    public Map getBsLogs(String date, Integer shard, String method, String[] uuid) {
        return service.GetBSLogs(date, shard, method, uuid);
    }
}
