package ru.yandex.autotests.direct.scriptrunner.service.scripts;

public class TaskVerifier {

    public static void checkTask(ScriptRunTask task) {
        if (task == null) {
            throw new IllegalArgumentException("scriptRunTask is null");
        }

        ScriptDBConfig dbConfig = task.getScriptDBConfig();
        ScriptRunParams runParams = task.getScriptRunParams();
        if (dbConfig == null) {
            throw new IllegalArgumentException("scriptRunTask.scriptDBConfig is null");
        }
        if (runParams == null) {
            throw new IllegalArgumentException("scriptRunTask.scriptRunParams is null");
        }

        String host = runParams.getHost();
        ScriptParams scriptParams = runParams.getScriptParams();
        if (host == null) {
            throw new IllegalArgumentException("scriptRunTask.scriptRunParams.host is null");
        }
        if (scriptParams == null) {
            throw new IllegalArgumentException("scriptRunTask.scriptRunParams.scriptParams is null");
        }
    }

}
