package ru.yandex.autotests.direct.scriptrunner.service.utils;

import org.apache.http.client.utils.URIBuilder;

import java.net.URI;
import java.net.URISyntaxException;

public class Environments {

    private static final String ENV_TC = "test-direct.yandex.ru";
    private static final String ENV_TC2 = "test2-direct.yandex.ru";

    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";

    private static final int TC_HTTP_PORT = 9000;
    private static final int TC_HTTPS_PORT = 9443;

    private static final String JSON_RPC_PATH = "/jsonrpc";
    private static final String DIRECT_CONFIG_PATH = "/DirectConfiguration";

    public static URI getJsonRpcServiceUrl(String hostName) {
        return getServiceUrl(hostName, JSON_RPC_PATH);
    }

    public static URI getDirectConfigurationUrl(String hostName) {
        return getServiceUrl(hostName, DIRECT_CONFIG_PATH);
    }

    private static URI getServiceUrl(String hostName, String servicePath) {
        try {
            URIBuilder builder = new URIBuilder()
                    .setScheme(SCHEME_HTTP)
                    .setHost(hostName)
                    .setPath(servicePath);

            if (hostName.equals(ENV_TC) || hostName.equals(ENV_TC2)) {
                builder.setPort(TC_HTTP_PORT);
            }

            return builder.build();
        } catch (URISyntaxException e) {
            throw new IllegalStateException("Can not build " + servicePath.replaceAll("/","")
                    + " service url for hostname " + hostName, e);
        }

    }



}
