#! /bin/bash

set -e
exec 2>&1

while (("$#")); do
    case "$1" in
        --dry-run) DRY_RUN=1; shift ;;
        * ) break ;;
    esac
done


if [ ! -z $DRY_RUN ]; then
    RUN_CMD="echo "
else
    RUN_CMD=""
fi


if [ -z $DRY_RUN ]; then
    DEF_RTR=`ip -o -6 route get 2a02:6b8::1:1 | cut -d ' ' -f 5`
    ip -6 route replace 64:ff9b::/96 via $DEF_RTR dev veth mtu 1450 advmss 1390
fi

NAME=$1
SHORT_NAME=$(echo $NAME | sed 's/direct-//')
MAIN_CLASS=$2 # ru.yandex.direct.web.DirectWebApp , ru.yandex.direct.api.v5.YandexDirectApiV5Application , ru.yandex.direct.intapi.IntapiApp

ENV=development
if [ ! -z "$3" ]; then
    ENV=$3
fi

PATH=/sbin:/usr/sbin:/bin:/usr/bin
LANG=en_US.UTF-8
DESC="$NAME"
CWD=/var/www/$NAME
GC_LOG=/var/log/yandex/$NAME.gc.log
ERROR_LOG=/var/log/yandex/$NAME.error.log

if [ -z $DRY_RUN ]; then
    VERSION=`cat /var/www/$NAME/version`
else
    VERSION=${VERSION:-version}
fi

JAVA=/usr/local/yandex-direct-jdk11/bin/java
LOG4JFILENAME=log4j2-deploy.xml
case "$ENV" in
    production) MEM_CPU_OPTS="-Xmx24G -Xms24G -XX:ActiveProcessorCount=10";;
    sandbox) MEM_CPU_OPTS="-Xmx24G -Xms24G -XX:ActiveProcessorCount=10";;
    *) MEM_CPU_OPTS="-Xmx8G -Xms2G -XX:ActiveProcessorCount=2";;
esac

if [[ "$ENV" != "sandbox" ]]; then
# wait for unified agent
while ! ${RUN_CMD} curl http://localhost:16301/status > /dev/null 2>&1; do sleep 1; done
fi

#fix dir rights
${RUN_CMD} chmod a+w -R /var/log/yandex/
${RUN_CMD} chmod a+rw -R $CWD


JAVA_HOME=/usr/local/yandex-direct-jdk11

if [[ ! -z "$USE_JDK17" ]] && [[ -d /usr/local/yandex-direct-jdk17 ]]; then
    JAVA_HOME=/usr/local/yandex-direct-jdk17
fi

case "$ENV" in
    dev7)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.dev7.json
        )
        ;;
    devtest)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.devtest.json
        )
        ;;
    testing)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.test.json
        )
        ;;
    sandbox)
        if [[ "$YANDEX_ENVIRONMENT" == "sandbox" ]]; then
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/sandbox-db-config.json
        )
        elif [[ "$YANDEX_ENVIRONMENT" == "sandbox_testing" ]]; then
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/np/db-config/db-config.sandboxtest.json
        )
        fi
        LOG4JFILENAME=log4j2.xml
        ;;
    production)
        JAVA_ADDITIONAL_ARGS=(
            -Ddb_config=zk:///direct/db-config.json
        )
        ;;
esac

JAVA_ADDITIONAL_ARGS+=(
    -Dnetwork_config=zk:///direct/network-config.json
)

JAVA_OPTS="$MEM_CPU_OPTS \
    -Dfile.encoding=UTF-8 \
    -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true \
    -Dlog4j2.formatMsgNoLookups=true \
    -Dsun.net.inetaddr.ttl=60 -Dsun.net.inetaddr.negative.ttl=0 \
    -Djava.util.Arrays.useLegacyMergeSort=true \
    -Dbuild.version="$VERSION" \
    -XX:-UsePerfData
    -XX:+UseG1GC
    -XX:MaxGCPauseMillis=100
    -Xlog:gc*=info,safepoint=info,age*=trace:file=$GC_LOG:time,uptime,level,tags:filecount=8,filesize=100M \
    -XX:+CrashOnOutOfMemoryError \
    -XX:+HeapDumpOnOutOfMemoryError \
    -XX:-OmitStackTraceInFastThrow \
    -XX:HeapDumpPath=/var/log/yandex/$NAME.hprof"

if [ "$NAME" = "direct-web" ] || [ "$NAME" = "direct-jobs" ]; then
    JAVA_OPTS+=(
        -Dsun.awt.fontconfig=/usr/local/yandex-direct-jdk11/lib/fonts/fontconfig.properties
        -Djdk.tls.client.protocols="TLSv1,TLSv1.1,TLSv1.2"
    )
fi

if [ "$NAME" = "direct-jobs" ] && [ "$ENV" = "production" ]; then
    JAVA_OPTS+=(
        -Xmx32g
        -Xms32g
    )
fi

if [ "$NAME" = "direct-binlog-logbrokerwriter" ] && [ -n "$DIRECT_BINLOGBROKER_ALLOW_EMPTY_STATE" ]; then
    JAVA_OPTS+=(
        -Dbinlogbroker.allow_empty_state="$DIRECT_BINLOGBROKER_ALLOW_EMPTY_STATE"
    )
fi

if [ -n "$DIRECT_JAVA_DB_SHARDS_NUM" ]; then
    JAVA_OPTS+=(
        -Ddb_shards="$DIRECT_JAVA_DB_SHARDS_NUM"
    )
fi

if [ "$NAME" = "direct-mysql-yt-sync" ]; then
    MEM_LIMIT="64g"
    JAVA_OPTS+=(
        -Dyt-sync.cluster=$YT_SYNC_CLUSTER_NAME \
        -Dyt-sync.sync-state=$YT_SYNC_CLUSTER_STATE \
        -DYT_SYNC_LOG_NAME="binlog-to-yt-$YT_SYNC_CLUSTER_NAME-$ENV" \
        # Лекарство от io.netty.handler.codec.TooLongFrameException: HTTP header is larger than 8192 bytes
        # https://st.yandex-team.ru/DIRECT-96850
        -Dhttp.netty.maxHeaderSize:16384 \
        # В рамках перехода на JDK 11
        -Djava.util.Arrays.useLegacyMergeSort=true \
        -Xms$MEM_LIMIT \
        -Xmx$MEM_LIMIT \
        -Dyt-sync.path.version=$YT_SYNC_VERSION \
        -Dyt-sync.mysql-server-id=$YT_SYNC_MYSQL_SERVER_ID
    )
    if [ "$MAIN_CLASS" = "ru.yandex.direct.mysql.RunM2Yt" ]; then
        JAVA_OPTS+=(
            -Dyt-sync.$YT_SYNC_CLUSTER_NAME.daily-snapshots.enabled=true \
            -Dyt-sync.$YT_SYNC_CLUSTER_NAME.verify-checksums=true
        )
    fi
    if [ "$MAIN_CLASS" = "ru.yandex.direct.mysql.RunB2Yt" -a -n "$DIRECT_B2YT_PROCESS_RESHARDING_EVENTS" ]; then
        JAVA_OPTS+=(
            -Dyt-sync.$YT_SYNC_CLUSTER_NAME.process-resharding-events="$DIRECT_B2YT_PROCESS_RESHARDING_EVENTS"
        )
    fi
fi

CLASSPATH="/var/www/$NAME/hotfix/$VERSION/classes/:/var/www/$NAME/$NAME/*:"

JAVA_ARGS=(
    -cp $CLASSPATH
    -Dlog4j.configurationFile=/etc/direct/$SHORT_NAME/logging-config/$LOG4JFILENAME
    -Djava.library.path=/var/www/$NAME/$NAME "$2"
    --log-configs-directory /etc/direct/$SHORT_NAME/logging-config/
    )

#Временный костылик для jobs в деплой TODO:DIRECT-147929
if [ "$NAME" = "direct-jobs" ]; then
    cp /var/www/direct-jobs/scheduler-version.new /var/www/direct-jobs/scheduler-version
    JAVA_ARGS+=(
        --job-scheduler-version "$(head -1 /var/www/direct-jobs/scheduler-version)"
        )
fi

if [[ -v DEPLOY_NODE_DC ]]; then
    DC_OPTS="-Ddirect.dc=$DEPLOY_NODE_DC"
else
    DC_OPTS=""
fi

${RUN_CMD} cd "$CWD"

${RUN_CMD} sudo -u nobody -H -E "$JAVA_HOME/bin/java" ${JAVA_OPTS[@]} $DC_OPTS ${JAVA_ADDITIONAL_ARGS[@]} ${JAVA_ARGS[@]}
