#!/usr/bin/python
# -*- coding: utf8 -*-

description = """
Скрипт упрощает жизнь в сценариях:
  * создать новый топик в LogBroker-е по аналогии с предыдущим"
  * удалить и создать топик заново

Скрипт в разработке, пользоваться с осторожностью!
Сгенерированные команды стоит перед выполнением читать и критически оценивать.

Генерирует команды для создания топика в логброкере по описанию в файле.
Формат файлов -- наш собственный, общий со скриптом dump-topics.py

Команды потом можно выполнить руками или |bash

В сгенерированных командах используется программа logbroker
Подробнее про программу logbroker: https://logbroker.yandex-team.ru/docs/interfaces/cli/

Пример использования:
./create-topic.py lbkx/direct/direct-ppcdict-binlog-log-json-query.topic.json lbkx/direct/direct-ppcdict-binlog-log-json.topic.json
"""


import os
import re
import sys

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')

import argparse
import copy
import getpass
import json
import requests
import socket
import subprocess
import time
import yaml
import tempfile

consumer_mode_translation = {
        "all original": "--all-original",
        "mirror to cluster kafka-bs": "--mirror kafka-bs",
        "mirror to cluster man": "--mirror man",
        "mirror to cluster myt": "--mirror myt",
        "mirror to cluster vla": "--mirror vla",
        "mirror to cluster sas": "--mirror sas",
        "mirror to cluster iva": "--mirror iva",
        }

def die(message=''):
    # комментарий от andy-ilyin@: может, лучше raise по месту с приблизительно подходящим текстом? стектрейс терять не хочется
    sys.stderr.write("%s\n" % message)
    exit(1)


def parse_options():
    my_name = os.path.basename( sys.argv[0] )
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    if len(extra) <= 0:
        die("expecting topico")

    opts.extra = extra

    return opts

def run():
    opts = parse_options()

    for f in opts.extra:
        with open(f) as json_file:
            o = json.load(json_file)

	cmds = []
	if o["type"] == "topic":
            cmds.append("logbroker -s %s schema create topic %s -p %s -y" % (o["logbroker_server"], o['path'], o['properties']['partitions'], ))
            for s, p in o['permissions'].iteritems():
                cmd = "logbroker -s %s permissions grant --subject %s --path %s --permissions %s -y" % (o["logbroker_server"], s, o['path'], " ".join(p))
                cmds.append(cmd)
            for r in o['read_rules']:
                cmd = "logbroker -s %s schema create read-rule -t %s -c %s %s -y" % (o["logbroker_server"], o['path'], r[0], consumer_mode_translation[r[1]])
                cmds.append(cmd)
        elif o["type"] == "consumer":
            cmds = []
            cmds.append("logbroker -s %s schema create consumer %s -y" % (o["logbroker_server"], o['path'] ))
            for s, p in o['permissions'].iteritems():
                cmd = "logbroker -s %s permissions grant --subject %s --path %s --permissions %s -y" % (o["logbroker_server"], s, o['path'], " ".join(p))
                cmds.append(cmd)
        else:
            die("unsupported file")

        print "\n".join(cmds)
        print ""

    exit(0)



if __name__ == '__main__':
    run();

