import argparse
import os
import time

from direct.solo.registered import get_objects_registry
from library.python.monitoring.solo.controller import Controller
from library.python.monitoring.solo.helpers.cli import configure_logging, SolomonEndpoint, JugglerEndpoint

import library.python.svn_version as sv
import library.python.vault_client as vault_client
import library.python.oauth as lpo

# yabs secret right now, not for use
YAV_SOLO_SECRET_ID = 'sec-01efy727n3s8t67rren6b7taep'
TOKENS = {'SOLOMON_TOKEN', 'JUGGLER_TOKEN', 'NANNY_TOKEN'}

JUGGLER_MARK = 'direct-autojuggler'


def parse_args():
    parser = argparse.ArgumentParser("Solomon checks creator")
    parser.add_argument(
        "--version", action="version",
        version="%(prog)s {version}".format(version=sv.svn_revision())
    )
    parser.add_argument("--debug", action="store_true", default=False, help="set logging debug level")
    parser.add_argument("--apply-changes", action='store_true', default=False)
    parser.add_argument("--oauth", action="store_true", default=False, help="use ssh key to get personal tokens")
    return parser.parse_args()


def process_all(apply_changes=False):
    controller = Controller(save=apply_changes,
                            solomon_endpoint=SolomonEndpoint.PRODUCTION,
                            juggler_endpoint=JugglerEndpoint.PRODUCTION,
                            solomon_token=os.environ["SOLOMON_TOKEN"],
                            juggler_token=os.environ["JUGGLER_TOKEN"],
                            juggler_mark=JUGGLER_MARK,
                            delete_untracked=True,
                            state_file_path="./state.json")
    controller.process(get_objects_registry(controller))


def main():
    args = parse_args()
    configure_logging(verbose=args.debug)
    if args.oauth:
        for token in TOKENS:
            # https://oauth.yandex-team.ru/client/d02dff40a30b4ff18d2d77c524085bf3
            os.environ[token] = lpo.get_token("d02dff40a30b4ff18d2d77c524085bf3", "7961228260b44fd1bab593980dba4f63")
    else:
        try:
            if not TOKENS <= set(os.environ.keys()):
                yav = vault_client.instances.Production().get_version(YAV_SOLO_SECRET_ID)['value']
                for token in TOKENS:
                    os.environ[token] = yav[token]
        except KeyError as e:
            print("Can't get token '{}'".format(repr(e)))
            exit(1)

    start_time = time.time()
    process_all(apply_changes=args.apply_changes)
    duration = int(time.time() - start_time)
    print('Successfully executed in {0} seconds!'.format(duration))


if __name__ == "__main__":
    print('Solomon and Juggler configuration applier')
    main()
