import itertools


def get_objects_registry(controller):
    from direct.solo.registered.alert import get_all_alerts  # noqa
    from direct.solo.registered.service import get_all_services  # noqa
    from direct.solo.registered.shard import get_all_shards  # noqa
    from direct.solo.registered.channel import get_all_channels  # noqa
    from direct.solo.registered.cluster import get_all_clusters  # noqa
    from direct.solo.registered.dashboard import get_all_dashboards  # noqa
    from direct.solo.registered.graph import get_all_graphs  # noqa
    from direct.solo.registered.juggler import get_all_checks  # noqa

    return list(itertools.chain(
        get_all_clusters(),
        get_all_services(),
        get_all_shards(),
        get_all_alerts(controller),
        get_all_channels(),
        get_all_graphs(),
        get_all_dashboards(),
        get_all_checks()
    ))
