from itertools import chain

from direct.solo.registered.alert import jobs, infra, balancer, java_apps, errorbooster, transport_queues, mds
from direct.solo.registered.alert import integrations


def get_all_alerts(controller):
    return list(chain(
        balancer.get_all_alerts(),
        errorbooster.get_all_alerts(controller),
        infra.get_all_alerts(),
        integrations.get_all_alerts(),
        java_apps.get_all_alerts(),
        jobs.get_alerts(),
        mds.get_all_alerts(),
        transport_queues.get_all_alerts(),
    ))
