import datetime

from juggler_sdk import Check, Child

from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, Expression
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects
from direct.solo.registered.sensors import balancer

balancer_fails_partner_disaster_alert = Alert(
    id="balancer_fails_partner_disaster_alert",
    project_id=projects.direct.id,
    name="balancer_fails_partner_disaster_alert",
    annotations={
        "host": "bsfront-l7-balancer",
        "service": "fails_partner",
        "description": "fails percent {{expression.fails_percent}}%\n"
                       "AWACS fails percent {{expression.awacs_fails_percent}}%"
    },
    type=Type(
        expression=Expression(
            program="""
            let awacs_fails = group_lines('sum', {0});
            let awacs_requests = group_lines('sum', {1});
            let awacs_fails_percent = (max(awacs_fails) > 0 ? max(awacs_fails / awacs_requests * 100.0) : 0.0);
            alarm_if(awacs_fails_percent > 5.0);
            warn_if(awacs_fails_percent > 1.0);
            """.format(balancer.fail,
                       balancer.requests
                       )
        )

    ),
    notification_channels={
        channels.direct_juggler.id
    },
    window_secs=int(datetime.timedelta(minutes=10).total_seconds()),
    delay_seconds=int(datetime.timedelta(minutes=1).total_seconds()),
)

balancer_fails_partner_disaster_juggler = Check(
    namespace="direct.prod",
    host=balancer_fails_partner_disaster_alert.annotations["host"],
    service="balancer_fails_partner_disaster",
    refresh_time=90, ttl=900,
    aggregator="logic_or",
    tags=["is_disaster", "marty", "warden_alert_create_spi", "call_needed", "disaster_alert", "yabs_partner"],
    children=[Child(
        host=balancer_fails_partner_disaster_alert.annotations["host"],
        service=balancer_fails_partner_disaster_alert.annotations["service"],
        group_type="HOST"
    )]
)

exports = [
    # temporary commented out
    # balancer_fails_partner_disaster_alert, balancer_fails_partner_disaster_juggler,
]
