from library.python.monitoring.solo.objects.solomon.v2 import Alert
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from library.python.monitoring.solo.objects.solomon.v2 import Type, Expression
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects


def create_5xx_alert(balancer, reporter, window_min, warn_rps, crit_rps):
    return Alert(
        id="l7-{}-{}-5xx".format(balancer, reporter),
        project_id=projects.direct.id,
        name="l7-{}-{}-5xx".format(balancer, reporter),
        annotations={
            "host": "direct-l7",
            "service": "l7-{}-{}-5xx".format(balancer, reporter),
            "description": "5xx http errors number on l7 balancer {}/{}".format(balancer, reporter)
        },
        description="Повышение уровня 500-ых ошибок в балансере {}/{}".format(balancer, reporter),
        type=Type(
            expression=Expression(
                program="""
                let rps500 = series_sum({0});

                // 3 rps * 5 min
                let crit_treshold = {1};
                let warn_treshold = {2};

                alarm_if(integrate(rps500) > crit_treshold);
                warn_if(integrate(rps500) > warn_treshold);
                """.format(
                    Sensor(
                        project="direct", cluster=balancer, service="awacs",
                        host="CLUSTER", sensor="report-{}-5xx".format(reporter)
                    ),
                    int(warn_rps * window_min * 60),
                    int(crit_rps * window_min * 60),
                )
            )

        ),
        notification_channels={channels.direct_juggler.id},
        window_secs=int(window_min * 60),
        delay_seconds=30,
    )


def get_all_alerts():
    return [
        create_5xx_alert("direct.yandex.ru", "service_total", 5, 900, 600)
    ]
