from library.python.monitoring.solo.objects.solomon.v2 import Alert, Type, Expression
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.channel import channels
from direct.solo.registered.project import projects

WINDOW_MINUTES = 10
ERROR_LIMIT_PER_SEC = 0.125
WARN_ERR_RATIO = 0.2
CRIT_ERR_RATIO = 0.5


def get_awacs_requests_sensor(sensor):
    return Sensor(
        project="direct", cluster="direct.yandex.ru", service="awacs", host="CLUSTER", sensor=sensor
    )


http_web_5xx_errors = Alert(
    id="web_5xx_errors",
    project_id=projects.direct.id,
    name="Фон ошибок в web # solo",
    description="Алерт проверяет уровень ошибок в web. Реагирует на стабильно высокий рейт ошибок. Толерантен к " +
                "разовым прострелам",
    window_secs=WINDOW_MINUTES * 60,
    delay_seconds=0,
    notification_channels={channels.direct_juggler_annotated.id},
    annotations={
        "jugglerHostSuffix": "java-web",
        "jugglerService": "awacs_errors",
        "url": "https://solomon.yandex-team.ru/admin/projects/direct/alerts/{{alert.id}}",
        "jugglerDescription": "{{#isOk}}OK{{/isOk}}" +
                              "{{^isOk}}Доля ошибок выше {{expression.err_limit_perc}}% для " +
                              "{{expression.err_exceeded_count}} из {{expression.points_to_analyze}} точек{{/isOk}}",
    },
    type=Type(
        expression=Expression(
            program="""
                let successes = {success_total_outgoing_sensor}-{success_check_outgoing_sensor};
                let errors = {fail_total_outgoing_sensor}-{fail_check_outgoing_sensor};

                let err_limit_perc = {err_limit_per_sec};
                let window = {window_minutes}m;

                // Доля точек выше порога для зажигания алёрта
                let warn_err_ratio = {warn_err_ratio};
                let crit_err_ratio = {crit_err_ratio};

                // одну точку выкидываем для красоты. 10m -- это 41 точка, например
                let points_to_analyze = count(tail(successes, window)) - 1;
                let warn_count_limit = points_to_analyze * warn_err_ratio;
                let crit_count_limit = points_to_analyze * crit_err_ratio;

                // Количество точек, для которых доля ошибок выше err_limit_perc
                let err_exceeded_count = count(drop_below(100.0 * tail(errors, points_to_analyze) / tail(successes, points_to_analyze), err_limit_perc));

                let is_crit = err_exceeded_count > crit_count_limit;
                alarm_if(is_crit);
                let is_warn = err_exceeded_count > warn_count_limit;
                warn_if(is_warn);
                """.format(
                success_total_outgoing_sensor=get_awacs_requests_sensor("report-service_total-outgoing_2xx"),
                success_check_outgoing_sensor=get_awacs_requests_sensor("report-announce_check-outgoing_2xx"),
                fail_total_outgoing_sensor=get_awacs_requests_sensor("report-service_total-outgoing_5xx"),
                fail_check_outgoing_sensor=get_awacs_requests_sensor("report-announce_check-outgoing_5xx"),
                err_limit_per_sec=ERROR_LIMIT_PER_SEC,
                window_minutes=WINDOW_MINUTES,
                warn_err_ratio=WARN_ERR_RATIO,
                crit_err_ratio=CRIT_ERR_RATIO,
            )
        )
    ),
)

exports = [http_web_5xx_errors]
