from itertools import chain
from urllib.parse import quote

from juggler_sdk import Check, Child

from library.python.monitoring.solo.controller import Controller

from direct.solo.registered.juggler.reference import get_warden_tags


def get_eb_link(filter):
    return 'https://error.yandex-team.ru/projects/direct?filter=' + quote(filter, safe='()')


ERROR_BOOSTER_HOST = 'api.error.yandex-team.ru'

FRONT_ALERT_DOC = {
    "type": "wiki",
    "title": "документация",
    "url": 'https://docs.yandex-team.ru/direct-dev/reference/alerts/frontend-errors',
}
EDIT_ALERT = {
    'title': 'Редактировать алерт',
    'url': 'https://error.yandex-team.ru/projects/direct/settings/alerts',
}

alert_mapping = {
    'alert-523': {'host': 'direct.error-booster', 'service': 'trending-errors-all-backends'},
    'alert-521': {'host': 'direct.error-booster', 'service': 'trending-errors-java-web'},
    'alert-525': {'host': 'direct.error-booster', 'service': 'trending-errors-java-api5'},
    'alert-526': {'host': 'direct.error-booster', 'service': 'trending-errors-java-intapi'},
    'alert-527': {'host': 'direct.error-booster', 'service': 'trending-errors-java-jobs'},

    'alert-531': {
        'host': 'direct.error-booster', 'service':
        'frontend-errors-disaster-alert',
        'tags':  get_warden_tags(slug='direct_web_mass_frontend_errors'),
        '_urls': [
            {
                'title': 'Error booster',
                'url': get_eb_link('service == frontend AND environment == production'
                                   + ' AND (block like ScreenErrorMessage OR source == uncaught)'
                                   + ' AND savedFilter == levelError AND errorTags notLike expected'),
            },
            FRONT_ALERT_DOC,
        ],
    },
    'alert-524': {'host': 'direct.error-booster', 'service': 'frontend-errors-new-errors', '_urls': [FRONT_ALERT_DOC]},
    'alert-530': {'host': 'direct.error-booster', 'service': 'frontend-errors-trending-errors', '_urls': [FRONT_ALERT_DOC]},
    'alert-535': {
        'host': 'direct.error-booster',
        'service': 'frontend-errors-operations-failure-alert',
        '_urls': [
            {
                'title': 'Error booster',
                'url': get_eb_link('environment == production AND sourceType == validationErrorVisibleForUser'),
            },
            FRONT_ALERT_DOC,
        ],
    },
}


def get_error_booster_aggregates(controller: Controller):
    for alert, info in alert_mapping.items():
        urls = [EDIT_ALERT]
        urls.extend(info.pop('_urls', []))
        yield Check(
            namespace='direct.prod',
            aggregator='logic_or',
            children=[Child(
                host=ERROR_BOOSTER_HOST,
                service=alert,
            )],
            ttl=1200,
            refresh_time=30,
            meta={
                'urls': urls,
            },
            **info
        )


def get_all_alerts(controller):
    return list(chain(
        get_error_booster_aggregates(controller),
    ))
