from itertools import chain

from . import chassis_jobs
from . import direct_mmm
from . import lbmoderation, lifeline, logshatter
from . import memcached, mysql_binlog_age, solomon_ppc, push_client, unified_agent, ydb
from .mdb import mongo, redis, mysql, tm


def get_all_alerts():
    return list(chain(
        chassis_jobs.get_all_alerts(),
        direct_mmm.get_all_alerts(),
        lifeline.get_all_alerts(),
        logshatter.get_all_alerts(),
        memcached.get_all_alerts(),
        mongo.get_all_alerts(),
        mysql.get_all_alerts(),
        mysql_binlog_age.get_all_alerts(),
        redis.get_all_alerts(),
        tm.get_all_alerts(),
        lbmoderation.get_all_alerts(),
        solomon_ppc.get_all_alerts(),
        push_client.get_all_alerts(),
        ydb.get_all_alerts(),
        unified_agent.get_all_alerts()
    ))
