from juggler_sdk import Check, Child, NotificationOptions

from direct.solo.registered.channel import channels
from direct.solo.registered.juggler import reference

CHECK_MARK = "chassis_jobs_mark"
HOST = "direct.checks.test"
CHASSIS_SERVICE = "direct.chassis"


def task_check(host, service, ttl, notifications=()):
    return Check(
        namespace=reference.NAMESPACE_TEST,
        host=host,
        service=service,
        ttl=ttl,
        mark=CHECK_MARK,
        refresh_time=90,
        aggregator="logic_and",
        aggregator_kwargs={"downtimes_mode": "skip"},
        children=[
            Child("direct-production@stage=direct-chassis-prod", service, "", "DEPLOY"),
        ],
        notifications=notifications,
    )


def subtask(task, ttl=900):
    host = "direct.checks.aggregation.test"
    service = CHASSIS_SERVICE + '.' + task
    return task_check(host, service, ttl)


subtasks = [
    subtask("DeployMonitor"),
    subtask("CommitMonitor"),
    subtask("HotfixMonitor", ttl=4*3600+600),
    subtask("YaDeployAppReleaseTicketCloser", ttl=960),
    subtask("AutocommentReleasesJob", ttl=960),
    subtask("AwaitingReleaseProcessor", ttl=3*15*60+120),
    subtask("OverviewAutocommentReleasesJob"),
    subtask("ChecklistReleasesJob", ttl=960),
    subtask("RegressionStartJob", ttl=960),
    subtask("AutotestsRestartJob"),
    subtask("YaDeployAppReleaser"),
    subtask("AquaTestsAutocommentReleasesJob"),
    subtask("UpdateNumberOfComplaintsJob", ttl=960),
    subtask("IncidentsStat", ttl=3*3*60*60+600),
    subtask("ScoreIncidentsToMarkUp", ttl=25200),
    subtask("ScoreIncidentsToFigureOut", ttl=3*60*60*2 + 1200),
    subtask("TuneReExportWorkers", ttl=12600),
    subtask("JobsReleaseToTesting", ttl=1800),
    subtask("BsTransportChecklistAdder"),
    subtask("JobsTestReport"),
    subtask("IncidentsReporter", ttl=5100),
    subtask("ActionItemsListUpdater", ttl=7500),
    subtask("RelatedIssuesUpdater", ttl=1380),
]


def chat_alert(login):
    return NotificationOptions(
        template_name="on_status_change",
        template_kwargs={
            "login": login,
            "method": "telegram",
            "status": [
                "CRIT",
                "OK",
            ],
        },
    )


chassis = Check(
    namespace=reference.NAMESPACE_TEST,
    host=HOST,
    mark=CHECK_MARK,
    service=CHASSIS_SERVICE + ".tasks",
    aggregator="logic_or",
    refresh_time=90,
    ttl=600,
    children=[Child(subtask.host, subtask.service) for subtask in subtasks],
    notifications=[
        chat_alert(channels.DIRECT_GROUP_INTERNAL_SYSTEMS_CHAT_ID),
        chat_alert("darkkeks"),
    ],
)


def get_all_alerts():
    export = [
        chassis,
    ]
    export.extend(subtasks)
    return export
