from juggler_sdk import Check, Child

APP_GROUPS = [
    'direct_ng_backs',
    'direct_frontends',
    'direct_java_web',
    'direct_java_api5',
    'direct_frontends_sandbox',
    'direct_java_intapi',
    'direct_java_jobs_rtc',
    'direct_java_b2yt',
    'direct_m2yt_full',
    'direct_java_binlogbroker',
    'direct_java_ess_router',
    'ppcdata',
    ]


def create_common_aliveness_check(service):

    children = []
    checks = []
    for grp in APP_GROUPS:
        child_host = 'direct.infra.%s.%s' % (service, grp.replace('direct_', ''))
        child_check = Check(
            namespace='direct.prod',
            host=child_host,
            service=service,
            refresh_time=90, ttl=900,
            aggregator="logic_or",
            description="%s aliveness" % service,
            children=[
                Child(
                    host=grp,
                    service=service,
                    group_type="CGROUP"
                ),
            ]
        )
        checks.append(child_check)
        children.append(Child(host=child_host, service=service, group_type='HOST'))

    check = Check(
        namespace="direct.prod",
        host='direct.infra.%s' % service,
        service=service,
        refresh_time=90, ttl=900,
        aggregator="logic_or",
        description="%s aliveness" % service,
        children=children)

    checks.append(check)
    return checks
