from juggler_sdk import Check, Child


ENVTYPES = {'production': 'prod',
            'dev7': 'np',
            'testing': 'np'}


def create_juggler_aggregates():
    export = []

    for envname, envshort in ENVTYPES.items():
        service_name = "direct-mysql-master-monitor-{}".format(envname)
        deploy_namespace = 'direct-production' if envname == 'production' else 'direct-np'
        deploy_name = "{0}@stage=direct-mmm-{1}".format(deploy_namespace, envname)
        tags_name = ['direct-subsystems-health', 'a_mark_direct.prod_subsystems'] if envname == 'production' else []
        aggregate = Check(
            namespace="direct.{}".format(envshort),
            host="direct.{0}_direct_mmm_{1}".format(envshort, envname),
            service=service_name,
            refresh_time=90, ttl=900,
            aggregator="logic_and",
            tags=tags_name,
            children=[create_child_check_for_cluster(deploy_name, service_name)]
        )
        export.append(aggregate)
    return export


def create_child_check_for_cluster(host, service_name):
    return Child(
        host=host,
        service=service_name,
        group_type="DEPLOY"
    )


def get_all_alerts():
    return create_juggler_aggregates()
