import re

from juggler_sdk import Check, Child

from library.python.monitoring.solo.objects.solomon.v2 import MultiAlert, Type, Expression
from direct.solo.registered.channel import channels
from direct.solo.registered.juggler.reference import DUTY_TS_TICKETS

notification_name_to_options = {"duty_ts_tickets": DUTY_TS_TICKETS}


def label_matchers(config):
    matchers_str = ""
    method_matcher = config.get("method_matcher")
    if method_matcher is not None:
        matchers_str += ",monitoring_method=\"{}\"".format(method_matcher)
    exclude_label_matchers = config.get("exclude_label_matchers")
    if exclude_label_matchers is not None and len(exclude_label_matchers) != 0:
        for key in exclude_label_matchers.keys():
            matchers_str += label_matchers_value_format(key, exclude_label_matchers[key])
    return matchers_str


def label_matchers_value_format(key, matcher_values):
    matcher_values_str = ""
    for value in matcher_values:
        matcher_values_str += ",{}!=\"{}\"".format(key, value)
    return matcher_values_str


def var_name(label):
    name = "".join(map(lambda s: s.capitalize(), re.split("[.:_]", label)))
    return "is" + name


def alert_name(config_file_name):
    return "lifeline_" + config_file_name[:-len(".json")]


def alert(project, name, config, juggler_description, program):
    export = []
    sensor = config.get("sensor")
    service = config.get("monitoring_service")
    cluster = config.get("version_cluster")
    window_secs = config.get("alert_window_minutes") * 60
    description = "Алерт для сервиса {} на основе сенсора {}" \
        .format(service, sensor)
    url = "https://solomon.yandex-team.ru/?project=direct&cluster={}&service=java-monitoring&l.sensor=minor_version&l.env=production&l.host=%21CLUSTER&graph=auto&stack=false&b=1w&e=" \
        .format(cluster)
    host = name + "." + project.id
    multi_alert = MultiAlert(
        id=name,
        project_id=project.id,
        name=name,
        annotations={
            "host": host,
            "service": "{{labels.monitoring_method}}",
            "description": juggler_description,
            "AppVersionUrl": url
        },
        description=description,
        type=Type(
            expression=Expression(
                program=program
            )

        ),
        notification_channels={channels.direct_test_juggler.id},
        window_secs=window_secs,
        delay_seconds=0,
        group_by_labels=set(config["labels"]),
    )
    export.append(multi_alert)

    notifications = []
    notification_name = config.get("notification_template")
    if notification_name is not None:
        notification_options = notification_name_to_options.get(notification_name)
        notifications.append(notification_options)
    aggregate_check = Check(
        namespace="direct.dev",
        host=host + ".aggregate",
        service="all",
        refresh_time=90, ttl=900,
        aggregator="logic_or",
        aggregator_kwargs={
            "nodata_mode": "force_ok"
        },
        children=[
            Child(host="(host=" + host + ")", service="all", group_type="EVENTS")
        ],
        notifications=notifications
    )
    export.append(aggregate_check)
    return export
